/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.mappers.SynchronizationMapper;
import com.ibanity.apis.client.products.ponto_connect.models.Synchronization;
import com.ibanity.apis.client.products.ponto_connect.models.create.SynchronizationCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.SynchronizationReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.SynchronizationService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class SynchronizationServiceImpl
implements SynchronizationService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public SynchronizationServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Synchronization create(SynchronizationCreateQuery synchronizationCreateQuery) {
        Synchronization synchronization = Synchronization.builder().resourceId(synchronizationCreateQuery.getResourceId()).resourceType(synchronizationCreateQuery.getResourceType()).subtype(synchronizationCreateQuery.getSubtype()).customerIpAddress(synchronizationCreateQuery.getCustomerIpAddress()).build();
        RequestApiModel request = ModelMapperHelper.buildRequest("synchronization", synchronization);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(this.getUrl()), request, synchronizationCreateQuery.getAdditionalHeaders(), synchronizationCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, SynchronizationMapper::map);
    }

    @Override
    public Synchronization find(SynchronizationReadQuery synchronizationReadQuery) {
        String url = this.getUrl() + "/" + synchronizationReadQuery.getSynchronizationId();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), synchronizationReadQuery.getAdditionalHeaders(), synchronizationReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, SynchronizationMapper::map);
    }

    private String getUrl() {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "synchronizations").replace("{synchronizationId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

