/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.OAuthHttpClient;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.Token;
import com.ibanity.apis.client.products.ponto_connect.models.create.TokenCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.models.refresh.TokenRefreshQuery;
import com.ibanity.apis.client.products.ponto_connect.models.revoke.TokenRevokeQuery;
import com.ibanity.apis.client.products.ponto_connect.services.TokenService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenServiceImpl
implements TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenServiceImpl.class);
    private final ApiUrlProvider apiUrlProvider;
    private final OAuthHttpClient oAuthHttpClient;

    public TokenServiceImpl(ApiUrlProvider apiUrlProvider, OAuthHttpClient oAuthHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.oAuthHttpClient = oAuthHttpClient;
    }

    @Override
    public void revoke(TokenRevokeQuery tokenRevokeQuery) {
        URI uri = URIHelper.buildUri(this.getUrl("revoke"));
        Map<String, String> deleteTokenRequestArguments = this.getDeleteTokenRequestArguments(tokenRevokeQuery.getToken());
        HttpResponse httpResponse = this.oAuthHttpClient.post(uri, tokenRevokeQuery.getAdditionalHeaders(), deleteTokenRequestArguments, tokenRevokeQuery.getClientSecret());
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
    }

    @Override
    public Token create(TokenCreateQuery tokenCreateQuery) {
        Map<String, String> accessTokenRequestArguments = this.getAccessTokenRequestArguments(tokenCreateQuery.getAuthorizationCode(), tokenCreateQuery.getCodeVerifier(), tokenCreateQuery.getRedirectUri());
        return this.performTokenRequest(accessTokenRequestArguments, tokenCreateQuery.getClientSecret(), tokenCreateQuery.getAdditionalHeaders());
    }

    @Override
    public Token refresh(TokenRefreshQuery tokenRefreshQuery) {
        Map<String, String> refreshTokenRequestArguments = this.getRefreshTokenRequestArguments(tokenRefreshQuery.getRefreshToken());
        return this.performTokenRequest(refreshTokenRequestArguments, tokenRefreshQuery.getClientSecret(), tokenRefreshQuery.getAdditionalHeaders());
    }

    private Token performTokenRequest(Map<String, String> tokenRequestArguments, String clientSecret, Map<String, String> additionalHeaders) {
        URI uri = URIHelper.buildUri(this.getUrl("token"));
        HttpResponse response = this.oAuthHttpClient.post(uri, additionalHeaders, tokenRequestArguments, clientSecret);
        try {
            Token token = (Token)IbanityUtils.objectMapper().readValue(response.getEntity().getContent(), Token.class);
            return token;
        }
        catch (IOException e) {
            LOGGER.error("oauth token response invalid", (Throwable)e);
            throw new RuntimeException("The response could not be converted.");
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private String getUrl(String path) {
        return this.apiUrlProvider.find(IbanityProduct.PontoConnect, "oauth2", path);
    }

    private Map<String, String> getDeleteTokenRequestArguments(String token) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", token);
        return arguments;
    }

    private Map<String, String> getAccessTokenRequestArguments(String authorizationCode, String codeVerifier, String redirectUri) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            arguments.put("grant_type", "client_credentials");
        } else {
            arguments.put("grant_type", "authorization_code");
            arguments.put("code", authorizationCode);
            arguments.put("code_verifier", codeVerifier);
            arguments.put("redirect_uri", redirectUri);
        }
        return arguments;
    }

    private Map<String, String> getRefreshTokenRequestArguments(String refreshToken) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("refresh_token", refreshToken);
        arguments.put("grant_type", "refresh_token");
        return arguments;
    }
}

