/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.models.Transaction;
import com.ibanity.apis.client.products.ponto_connect.models.read.TransactionReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.TransactionsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.TransactionService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class TransactionServiceImpl
implements TransactionService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public TransactionServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Transaction find(TransactionReadQuery transactionReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(transactionReadQuery.getAccountId()) + "/" + transactionReadQuery.getTransactionId());
        HttpResponse response = this.ibanityHttpClient.get(uri, transactionReadQuery.getAdditionalHeaders(), transactionReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, Transaction.class);
    }

    @Override
    public IbanityCollection<Transaction> list(TransactionsReadQuery transactionsReadQuery) {
        IbanityPagingSpec pagingSpec = transactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI uri = URIHelper.buildUri(this.getUrl(transactionsReadQuery.getAccountId()), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, transactionsReadQuery.getAdditionalHeaders(), transactionsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, Transaction.class);
    }

    @Override
    public IbanityCollection<Transaction> listUpdatedForSynchronization(TransactionsReadQuery transactionsReadQuery) {
        IbanityPagingSpec pagingSpec = transactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI uri = URIHelper.buildUri(this.getUrlForSynchronizationId(transactionsReadQuery.getSynchronizationId()), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, transactionsReadQuery.getAdditionalHeaders(), transactionsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, Transaction.class);
    }

    private String getUrl(UUID accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "transactions").replace("{accountId}", accountId.toString()).replace("{transactionId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private String getUrlForSynchronizationId(UUID synchronizationId) {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "synchronization", "updatedTransactions").replace("{synchronizationId}", synchronizationId.toString());
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

