/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.Userinfo;
import com.ibanity.apis.client.products.ponto_connect.models.read.UserinfoReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.UserinfoService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserinfoServiceImpl
implements UserinfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserinfoServiceImpl.class);
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public UserinfoServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Userinfo getUserinfo(UserinfoReadQuery readQuery) {
        URI uri = URIHelper.buildUri(this.getUrl());
        HttpResponse response = this.ibanityHttpClient.get(uri, readQuery.getAdditionalHeaders(), readQuery.getAccessToken());
        try {
            Userinfo userinfo = (Userinfo)IbanityUtils.objectMapper().readValue(response.getEntity().getContent(), Userinfo.class);
            return userinfo;
        }
        catch (IOException e) {
            LOGGER.error("userinfo response invalid", (Throwable)e);
            throw new RuntimeException("The response could not be parsed.");
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private String getUrl() {
        return this.apiUrlProvider.find(IbanityProduct.PontoConnect, "userinfo");
    }
}

