/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.sandbox.models.FinancialInstitutionAccount;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.create.FinancialInstitutionAccountCreationQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.delete.FinancialInstitutionAccountDeleteQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionAccountReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionAccountsReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.services.FinancialInstitutionAccountsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionAccountsServiceImpl
implements FinancialInstitutionAccountsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionAccountsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitutionAccount find(FinancialInstitutionAccountReadQuery accountReadQuery) {
        String url = this.getUrl(accountReadQuery.getFinancialInstitutionId().toString(), accountReadQuery.getFinancialInstitutionUserId().toString(), accountReadQuery.getFinancialInstitutionAccountId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    @Override
    public IbanityCollection<FinancialInstitutionAccount> list(FinancialInstitutionAccountsReadQuery accountsReadQuery) {
        String url = this.getUrl(accountsReadQuery.getFinancialInstitutionId().toString(), accountsReadQuery.getFinancialInstitutionUserId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, accountsReadQuery.getPagingSpec()));
        return IbanityModelMapper.mapCollection(response, this.responseMapping());
    }

    @Override
    public FinancialInstitutionAccount delete(FinancialInstitutionAccountDeleteQuery accountDeleteQuery) {
        String url = this.getUrl(accountDeleteQuery.getFinancialInstitutionId().toString(), accountDeleteQuery.getFinancialInstitutionUserId().toString(), accountDeleteQuery.getFinancialInstitutionAccountId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitutionAccount.class);
    }

    @Override
    public FinancialInstitutionAccount create(FinancialInstitutionAccountCreationQuery query) {
        String url = this.getUrl(query.getFinancialInstitutionId().toString(), query.getFinancialInstitutionUserId().toString(), "");
        FinancialInstitutionAccount financialInstitutionAccount = this.mapRequest(query);
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionAccount", financialInstitutionAccount);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private FinancialInstitutionAccount mapRequest(FinancialInstitutionAccountCreationQuery query) {
        return ((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)((FinancialInstitutionAccount.FinancialInstitutionAccountBuilder)FinancialInstitutionAccount.builder().description(query.getDescription())).reference(query.getReference())).referenceType(query.getReferenceType())).availableBalance(query.getAvailableBalance())).currentBalance(query.getCurrentBalance())).currency(query.getCurrency())).subtype(query.getSubtype())).product(query.getProduct())).holderName(query.getHolderName())).currentBalanceChangedAt(query.getCurrentBalanceChangedAt())).currentBalanceReferenceDate(query.getCurrentBalanceReferenceDate())).availableBalanceChangedAt(query.getAvailableBalanceChangedAt())).availableBalanceReferenceDate(query.getAvailableBalanceReferenceDate())).build();
    }

    private String getUrl(String financialInstitutionId, String financialInstitutionUserId, String financialInstutionAccountId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "sandbox", "financialInstitution", "financialInstitutionAccounts").replace("{financialInstitutionId}", financialInstitutionId).replace("{financialInstitutionUserId}", financialInstitutionUserId).replace("{financialInstitutionAccountId}", financialInstutionAccountId), (String)"/");
    }

    private Function<DataApiModel, FinancialInstitutionAccount> responseMapping() {
        return dataApiModel -> {
            RelationshipsApiModel financialInstitution = dataApiModel.getRelationships().get("financialInstitution");
            RelationshipsApiModel financialInstitutionUser = dataApiModel.getRelationships().get("financialInstitutionUser");
            FinancialInstitutionAccount financialInstitutionAccount = IbanityModelMapper.toIbanityModel(dataApiModel, FinancialInstitutionAccount.class);
            financialInstitutionAccount.setFinancialInstitutionId(UUID.fromString(financialInstitution.getData().getId()));
            financialInstitutionAccount.setFinancialInstitutionUserId(UUID.fromString(financialInstitutionUser.getData().getId()));
            return financialInstitutionAccount;
        };
    }
}

