/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.sandbox.models.FinancialInstitutionHolding;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.create.FinancialInstitutionHoldingCreationQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.delete.FinancialInstitutionHoldingDeleteQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionHoldingReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionHoldingsReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.services.FinancialInstitutionHoldingsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionHoldingsServiceImpl
implements FinancialInstitutionHoldingsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionHoldingsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitutionHolding find(FinancialInstitutionHoldingReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionUserId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), readQuery.getFinancialInstitutionHoldingId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    @Override
    public IbanityCollection<FinancialInstitutionHolding> list(FinancialInstitutionHoldingsReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionUserId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, readQuery.getPagingSpec()));
        return IbanityModelMapper.mapCollection(response, this.responseMapping());
    }

    @Override
    public FinancialInstitutionHolding delete(FinancialInstitutionHoldingDeleteQuery deleteQuery) {
        String url = this.getUrl(deleteQuery.getFinancialInstitutionId().toString(), deleteQuery.getFinancialInstitutionUserId().toString(), deleteQuery.getFinancialInstitutionAccountId().toString(), deleteQuery.getFinancialInstitutionHoldingId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitutionHolding.class);
    }

    @Override
    public FinancialInstitutionHolding create(FinancialInstitutionHoldingCreationQuery creationQuery) {
        FinancialInstitutionHolding transaction = this.requestMapping(creationQuery);
        String url = this.getUrl(creationQuery.getFinancialInstitutionId().toString(), creationQuery.getFinancialInstitutionUserId().toString(), creationQuery.getFinancialInstitutionAccountId().toString(), "");
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionHolding", transaction);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private String getUrl(String financialInstitutionId, String financialInstitutionUserId, String financialInstitutionAccountId, String financialInstitutionHoldingId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "sandbox", "financialInstitution", "financialInstitutionAccount", "financialInstitutionHoldings").replace("{financialInstitutionId}", financialInstitutionId).replace("{financialInstitutionUserId}", financialInstitutionUserId).replace("{financialInstitutionAccountId}", financialInstitutionAccountId).replace("{financialInstitutionHoldingId}", financialInstitutionHoldingId), (String)"/");
    }

    private FinancialInstitutionHolding requestMapping(FinancialInstitutionHoldingCreationQuery holdingCreationQuery) {
        return ((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)((FinancialInstitutionHolding.FinancialInstitutionHoldingBuilder)FinancialInstitutionHolding.builder().totalValuationCurrency(holdingCreationQuery.getTotalValuationCurrency())).totalValuation(holdingCreationQuery.getTotalValuation())).subtype(holdingCreationQuery.getSubtype())).referenceType(holdingCreationQuery.getReferenceType())).reference(holdingCreationQuery.getReference())).quantity(holdingCreationQuery.getQuantity())).name(holdingCreationQuery.getName())).lastValuationDate(holdingCreationQuery.getLastValuationDate())).lastValuationCurrency(holdingCreationQuery.getLastValuationCurrency())).lastValuation(holdingCreationQuery.getLastValuation())).build();
    }

    private Function<DataApiModel, FinancialInstitutionHolding> responseMapping() {
        return dataApiModel -> {
            FinancialInstitutionHolding financialInstitutionHolding = IbanityModelMapper.toIbanityModel(dataApiModel, FinancialInstitutionHolding.class);
            String accountId = dataApiModel.getRelationships().get("financialInstitutionAccount").getData().getId();
            financialInstitutionHolding.setFinancialInstitutionAccountId(UUID.fromString(accountId));
            return financialInstitutionHolding;
        };
    }
}

