/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.sandbox.models.FinancialInstitutionTransaction;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.create.FinancialInstitutionTransactionCreationQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.delete.FinancialInstitutionTransactionDeleteQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionTransactionReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionTransactionsReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.update.FinancialInstitutionTransactionUpdateQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.services.FinancialInstitutionTransactionsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionTransactionsServiceImpl
implements FinancialInstitutionTransactionsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionTransactionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitutionTransaction find(FinancialInstitutionTransactionReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionUserId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), readQuery.getFinancialInstitutionTransactionId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    @Override
    public IbanityCollection<FinancialInstitutionTransaction> list(FinancialInstitutionTransactionsReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionUserId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, readQuery.getPagingSpec()));
        return IbanityModelMapper.mapCollection(response, this.responseMapping());
    }

    @Override
    public FinancialInstitutionTransaction delete(FinancialInstitutionTransactionDeleteQuery deleteQuery) {
        String url = this.getUrl(deleteQuery.getFinancialInstitutionId().toString(), deleteQuery.getFinancialInstitutionUserId().toString(), deleteQuery.getFinancialInstitutionAccountId().toString(), deleteQuery.getFinancialInstitutionTransactionId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitutionTransaction.class);
    }

    @Override
    public FinancialInstitutionTransaction create(FinancialInstitutionTransactionCreationQuery creationQuery) {
        FinancialInstitutionTransaction transaction = this.createRequestMapping(creationQuery);
        String url = this.getUrl(creationQuery.getFinancialInstitutionId().toString(), creationQuery.getFinancialInstitutionUserId().toString(), creationQuery.getFinancialInstitutionAccountId().toString(), "");
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionTransaction", transaction);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    @Override
    public FinancialInstitutionTransaction update(FinancialInstitutionTransactionUpdateQuery updateQuery) {
        FinancialInstitutionTransaction transaction = this.updateRequestMapping(updateQuery);
        String url = this.getUrl(updateQuery.getFinancialInstitutionId().toString(), updateQuery.getFinancialInstitutionUserId().toString(), updateQuery.getFinancialInstitutionAccountId().toString(), updateQuery.getFinancialInstitutionTransactionId().toString());
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionTransaction", transaction);
        HttpResponse response = this.ibanityHttpClient.patch(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private String getUrl(String financialInstitutionId, String financialInstitutionUserId, String financialInstitutionAccountId, String financialInstitutionTransactionId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "sandbox", "financialInstitution", "financialInstitutionAccount", "financialInstitutionTransactions").replace("{financialInstitutionId}", financialInstitutionId).replace("{financialInstitutionUserId}", financialInstitutionUserId).replace("{financialInstitutionAccountId}", financialInstitutionAccountId).replace("{financialInstitutionTransactionId}", financialInstitutionTransactionId), (String)"/");
    }

    private FinancialInstitutionTransaction createRequestMapping(FinancialInstitutionTransactionCreationQuery transactionCreationQuery) {
        return ((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)FinancialInstitutionTransaction.builder().amount(transactionCreationQuery.getAmount())).currency(transactionCreationQuery.getCurrency())).remittanceInformation(transactionCreationQuery.getRemittanceInformation())).remittanceInformationType(transactionCreationQuery.getRemittanceInformationType())).counterpartName(transactionCreationQuery.getCounterpartName())).counterpartReference(transactionCreationQuery.getCounterpartReference())).valueDate(transactionCreationQuery.getValueDate())).executionDate(transactionCreationQuery.getExecutionDate())).description(transactionCreationQuery.getDescription())).bankTransactionCode(transactionCreationQuery.getBankTransactionCode())).proprietaryBankTransactionCode(transactionCreationQuery.getProprietaryBankTransactionCode())).endToEndId(transactionCreationQuery.getEndToEndId())).purposeCode(transactionCreationQuery.getPurposeCode())).mandateId(transactionCreationQuery.getMandateId())).creditorId(transactionCreationQuery.getCreditorId())).additionalInformation(transactionCreationQuery.getAdditionalInformation())).cardReference(transactionCreationQuery.getCardReference())).cardReferenceType(transactionCreationQuery.getCardReferenceType())).fee(transactionCreationQuery.getFee())).automaticBooking(transactionCreationQuery.isAutomaticBooking())).build();
    }

    private FinancialInstitutionTransaction updateRequestMapping(FinancialInstitutionTransactionUpdateQuery transactionUpdateQuery) {
        return ((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)FinancialInstitutionTransaction.builder().amount(transactionUpdateQuery.getAmount())).currency(transactionUpdateQuery.getCurrency())).remittanceInformation(transactionUpdateQuery.getRemittanceInformation())).remittanceInformationType(transactionUpdateQuery.getRemittanceInformationType())).counterpartName(transactionUpdateQuery.getCounterpartName())).counterpartReference(transactionUpdateQuery.getCounterpartReference())).valueDate(transactionUpdateQuery.getValueDate())).executionDate(transactionUpdateQuery.getExecutionDate())).description(transactionUpdateQuery.getDescription())).bankTransactionCode(transactionUpdateQuery.getBankTransactionCode())).proprietaryBankTransactionCode(transactionUpdateQuery.getProprietaryBankTransactionCode())).endToEndId(transactionUpdateQuery.getEndToEndId())).purposeCode(transactionUpdateQuery.getPurposeCode())).mandateId(transactionUpdateQuery.getMandateId())).creditorId(transactionUpdateQuery.getCreditorId())).additionalInformation(transactionUpdateQuery.getAdditionalInformation())).build();
    }

    private Function<DataApiModel, FinancialInstitutionTransaction> responseMapping() {
        return dataApiModel -> {
            FinancialInstitutionTransaction financialInstitutionTransaction = IbanityModelMapper.toIbanityModel(dataApiModel, FinancialInstitutionTransaction.class);
            String accountId = dataApiModel.getRelationships().get("financialInstitutionAccount").getData().getId();
            financialInstitutionTransaction.setFinancialInstitutionAccountId(UUID.fromString(accountId));
            return financialInstitutionTransaction;
        };
    }
}

