/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.sandbox.models.FinancialInstitutionUser;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.delete.FinancialInstitutionUserDeleteQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionUserReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.read.FinancialInstitutionUsersReadQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.update.FinancialInstitutionUserUpdateQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.services.FinancialInstitutionUsersService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionUsersServiceImpl
implements FinancialInstitutionUsersService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionUsersServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IbanityCollection<FinancialInstitutionUser> list(FinancialInstitutionUsersReadQuery usersReadQuery) {
        String url = this.getUrl("");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, usersReadQuery.getPagingSpec()));
        return IbanityModelMapper.mapCollection(response, FinancialInstitutionUser.class);
    }

    @Override
    public FinancialInstitutionUser find(FinancialInstitutionUserReadQuery userReadQuery) {
        String url = this.getUrl(userReadQuery.getFinancialInstitutionUserId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitutionUser.class);
    }

    @Override
    public FinancialInstitutionUser delete(FinancialInstitutionUserDeleteQuery userDeleteQuery) {
        String url = this.getUrl(userDeleteQuery.getFinancialInstitutionUserId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitutionUser.class);
    }

    @Override
    public FinancialInstitutionUser create(FinancialInstitutionUserUpdateQuery userCreationQuery) {
        FinancialInstitutionUser financialInstitutionUser = this.mapRequest(userCreationQuery);
        String url = this.getUrl("");
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionUser", financialInstitutionUser);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, FinancialInstitutionUser.class);
    }

    @Override
    public FinancialInstitutionUser update(FinancialInstitutionUserUpdateQuery userUpdateQuery) {
        FinancialInstitutionUser financialInstitutionUser = this.mapRequest(userUpdateQuery);
        String url = this.getUrl(userUpdateQuery.getFinancialInstitutionUserId().toString());
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionUser", financialInstitutionUser);
        HttpResponse response = this.ibanityHttpClient.patch(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, FinancialInstitutionUser.class);
    }

    private FinancialInstitutionUser mapRequest(FinancialInstitutionUserUpdateQuery userUpdateQuery) {
        return FinancialInstitutionUser.builder().login(userUpdateQuery.getLogin()).password(userUpdateQuery.getPassword()).firstName(userUpdateQuery.getFirstName()).lastName(userUpdateQuery.getLastName()).build();
    }

    private String getUrl(String financialInstitutionUserId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "sandbox", "financialInstitutionUsers").replace("{financialInstitutionUserId}", financialInstitutionUserId), (String)"/");
    }
}

