/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.FinancialInstitution;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.create.FinancialInstitutionCreationQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.delete.FinancialInstitutionDeleteQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.models.factory.update.FinancialInstitutionUpdateQuery;
import com.ibanity.apis.client.products.xs2a.sandbox.services.SandboxFinancialInstitutionsService;
import com.ibanity.apis.client.products.xs2a.services.impl.FinancialInstitutionsServiceImpl;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class SandboxFinancialInstitutionsServiceImpl
extends FinancialInstitutionsServiceImpl
implements SandboxFinancialInstitutionsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public SandboxFinancialInstitutionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        super(apiUrlProvider, ibanityHttpClient);
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitution create(FinancialInstitutionCreationQuery financialInstitutionCreationQuery) {
        FinancialInstitution financialInstitution = FinancialInstitution.builder().sandbox(Boolean.TRUE).name(financialInstitutionCreationQuery.getName()).country(financialInstitutionCreationQuery.getCountry()).bic(financialInstitutionCreationQuery.getBic()).logoUrl(financialInstitutionCreationQuery.getLogoUrl()).authorizationModels(this.getAuthorizationModels(financialInstitutionCreationQuery)).sharedBrandReference(financialInstitutionCreationQuery.getSharedBrandReference()).sharedBrandName(financialInstitutionCreationQuery.getSharedBrandName()).financialInstitutionCustomerReferenceRequired(financialInstitutionCreationQuery.isFinancialInstitutionCustomerReferenceRequired()).timeZone(financialInstitutionCreationQuery.getTimeZone()).build();
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitution", financialInstitution);
        String url = this.getSandboxUrl("");
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    @Override
    public FinancialInstitution update(FinancialInstitutionUpdateQuery financialInstitutionUpdateQuery) {
        FinancialInstitution financialInstitution = FinancialInstitution.builder().name(financialInstitutionUpdateQuery.getName()).country(financialInstitutionUpdateQuery.getCountry()).bic(financialInstitutionUpdateQuery.getBic()).logoUrl(financialInstitutionUpdateQuery.getLogoUrl()).authorizationModels(null).sandbox(true).sharedBrandReference(financialInstitutionUpdateQuery.getSharedBrandReference()).sharedBrandName(financialInstitutionUpdateQuery.getSharedBrandName()).financialInstitutionCustomerReferenceRequired(financialInstitutionUpdateQuery.isFinancialInstitutionCustomerReferenceRequired()).timeZone(financialInstitutionUpdateQuery.getTimeZone()).build();
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitution", financialInstitution);
        String url = this.getSandboxUrl(financialInstitutionUpdateQuery.getFinancialInstitutionId().toString());
        HttpResponse response = this.ibanityHttpClient.patch(URIHelper.buildUri(url), request);
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    @Override
    public FinancialInstitution delete(FinancialInstitutionDeleteQuery financialInstitutionDeleteQuery) {
        String url = this.getSandboxUrl(financialInstitutionDeleteQuery.getFinancialInstitutionId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url));
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    private List<String> getAuthorizationModels(FinancialInstitutionCreationQuery financialInstitutionCreationQuery) {
        return financialInstitutionCreationQuery.getAuthorizationModels().isEmpty() ? null : financialInstitutionCreationQuery.getAuthorizationModels();
    }

    private String getSandboxUrl(String financialInstitutionId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "sandbox", "financialInstitutions").replace("{financialInstitutionId}", financialInstitutionId), (String)"/");
    }
}

