/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.create.AccountInformationAccessRequestAuthorizationCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.links.AccountInformationAccessRequestAuthorizationLinks;
import com.ibanity.apis.client.products.xs2a.services.AccountInformationAccessRequestAuthorizationsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountInformationAccessRequestAuthorizationsServiceImpl
implements AccountInformationAccessRequestAuthorizationsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountInformationAccessRequestAuthorizationsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequestAuthorization create(AccountInformationAccessRequestAuthorizationCreationQuery authorizationCreationQuery) {
        UUID financialInstitutionId = authorizationCreationQuery.getFinancialInstitutionId();
        UUID accountInformationAccessRequestId = authorizationCreationQuery.getAccountInformationAccessRequestId();
        URI uri = this.getUrl(financialInstitutionId, accountInformationAccessRequestId);
        AccountInformationAccessRequestAuthorization ibanityModel = this.mapAttributes(authorizationCreationQuery);
        AccountInformationAccessRequestAuthorizationMeta meta = this.mapMeta(authorizationCreationQuery);
        RequestApiModel request = ModelMapperHelper.buildRequest("authorization", ibanityModel, meta);
        HttpResponse response = this.ibanityHttpClient.post(uri, request, authorizationCreationQuery.getAdditionalHeaders(), authorizationCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private AccountInformationAccessRequestAuthorizationMeta mapMeta(AccountInformationAccessRequestAuthorizationCreationQuery authorizationCreationQuery) {
        return AccountInformationAccessRequestAuthorizationMeta.builder().credentialsEncryptionKey(authorizationCreationQuery.getCredentialsEncryptionKey()).build();
    }

    private URI getUrl(UUID financialInstitutionId, UUID accountInformationAccessRequestId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "accountInformationAccessRequest", "authorizations").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountInformationAccessRequestId}", accountInformationAccessRequestId.toString()).replace("{authorizationId}", "");
        return URIHelper.buildUri(StringUtils.removeEnd((String)url, (String)"/"));
    }

    private AccountInformationAccessRequestAuthorization mapAttributes(AccountInformationAccessRequestAuthorizationCreationQuery authorizationCreationQuery) {
        return AccountInformationAccessRequestAuthorization.builder().queryParameters(authorizationCreationQuery.getQueryParameters()).build();
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequestAuthorization> responseMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequestAuthorization accountInformationAccessRequestAuthorization = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequestAuthorization.class);
            if (dataApiModel.getLinks() != null && dataApiModel.getLinks().getNextRedirect() != null) {
                accountInformationAccessRequestAuthorization.setLinks(AccountInformationAccessRequestAuthorizationLinks.builder().nextRedirect(dataApiModel.getLinks().getNextRedirect()).build());
            }
            return accountInformationAccessRequestAuthorization;
        };
    }

    static class AccountInformationAccessRequestAuthorization
    implements IbanityModel {
        public static final String RESOURCE_TYPE = "authorization";
        public static final String API_URL_TAG_ID = "{authorizationId}";
        private UUID id;
        private String selfLink;
        private String requestId;
        private Map<String, String> queryParameters;

        @Generated
        private static Map<String, String> $default$queryParameters() {
            return Collections.emptyMap();
        }

        @Generated
        public static AccountInformationAccessRequestAuthorizationBuilder builder() {
            return new AccountInformationAccessRequestAuthorizationBuilder();
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getSelfLink() {
            return this.selfLink;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public Map<String, String> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        @Generated
        public void setId(UUID id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setSelfLink(String selfLink) {
            this.selfLink = selfLink;
        }

        @Override
        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = queryParameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountInformationAccessRequestAuthorization)) {
                return false;
            }
            AccountInformationAccessRequestAuthorization other = (AccountInformationAccessRequestAuthorization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$selfLink = this.getSelfLink();
            String other$selfLink = other.getSelfLink();
            if (this$selfLink == null ? other$selfLink != null : !this$selfLink.equals(other$selfLink)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            Map<String, String> this$queryParameters = this.getQueryParameters();
            Map<String, String> other$queryParameters = other.getQueryParameters();
            return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountInformationAccessRequestAuthorization;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $selfLink = this.getSelfLink();
            result = result * 59 + ($selfLink == null ? 43 : $selfLink.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            Map<String, String> $queryParameters = this.getQueryParameters();
            result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountInformationAccessRequestAuthorizationsServiceImpl.AccountInformationAccessRequestAuthorization(id=" + this.getId() + ", selfLink=" + this.getSelfLink() + ", requestId=" + this.getRequestId() + ", queryParameters=" + this.getQueryParameters() + ")";
        }

        @Generated
        public AccountInformationAccessRequestAuthorization() {
            this.queryParameters = AccountInformationAccessRequestAuthorization.$default$queryParameters();
        }

        @Generated
        private AccountInformationAccessRequestAuthorization(UUID id, String selfLink, String requestId, Map<String, String> queryParameters) {
            this.id = id;
            this.selfLink = selfLink;
            this.requestId = requestId;
            this.queryParameters = queryParameters;
        }

        @Generated
        public static class AccountInformationAccessRequestAuthorizationBuilder {
            @Generated
            private UUID id;
            @Generated
            private String selfLink;
            @Generated
            private String requestId;
            @Generated
            private boolean queryParameters$set;
            @Generated
            private Map<String, String> queryParameters$value;

            @Generated
            AccountInformationAccessRequestAuthorizationBuilder() {
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationBuilder selfLink(String selfLink) {
                this.selfLink = selfLink;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationBuilder queryParameters(Map<String, String> queryParameters) {
                this.queryParameters$value = queryParameters;
                this.queryParameters$set = true;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestAuthorization build() {
                Map queryParameters$value = this.queryParameters$value;
                if (!this.queryParameters$set) {
                    queryParameters$value = AccountInformationAccessRequestAuthorization.$default$queryParameters();
                }
                return new AccountInformationAccessRequestAuthorization(this.id, this.selfLink, this.requestId, queryParameters$value);
            }

            @Generated
            public String toString() {
                return "AccountInformationAccessRequestAuthorizationsServiceImpl.AccountInformationAccessRequestAuthorization.AccountInformationAccessRequestAuthorizationBuilder(id=" + this.id + ", selfLink=" + this.selfLink + ", requestId=" + this.requestId + ", queryParameters$value=" + this.queryParameters$value + ")";
            }
        }
    }

    static class AccountInformationAccessRequestAuthorizationMeta {
        private String credentialsEncryptionKey;

        @Generated
        public static AccountInformationAccessRequestAuthorizationMetaBuilder builder() {
            return new AccountInformationAccessRequestAuthorizationMetaBuilder();
        }

        @Generated
        public String getCredentialsEncryptionKey() {
            return this.credentialsEncryptionKey;
        }

        @Generated
        public void setCredentialsEncryptionKey(String credentialsEncryptionKey) {
            this.credentialsEncryptionKey = credentialsEncryptionKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountInformationAccessRequestAuthorizationMeta)) {
                return false;
            }
            AccountInformationAccessRequestAuthorizationMeta other = (AccountInformationAccessRequestAuthorizationMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$credentialsEncryptionKey = this.getCredentialsEncryptionKey();
            String other$credentialsEncryptionKey = other.getCredentialsEncryptionKey();
            return !(this$credentialsEncryptionKey == null ? other$credentialsEncryptionKey != null : !this$credentialsEncryptionKey.equals(other$credentialsEncryptionKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountInformationAccessRequestAuthorizationMeta;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $credentialsEncryptionKey = this.getCredentialsEncryptionKey();
            result = result * 59 + ($credentialsEncryptionKey == null ? 43 : $credentialsEncryptionKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountInformationAccessRequestAuthorizationsServiceImpl.AccountInformationAccessRequestAuthorizationMeta(credentialsEncryptionKey=" + this.getCredentialsEncryptionKey() + ")";
        }

        @Generated
        public AccountInformationAccessRequestAuthorizationMeta() {
        }

        @Generated
        private AccountInformationAccessRequestAuthorizationMeta(String credentialsEncryptionKey) {
            this.credentialsEncryptionKey = credentialsEncryptionKey;
        }

        @Generated
        public static class AccountInformationAccessRequestAuthorizationMetaBuilder {
            @Generated
            private String credentialsEncryptionKey;

            @Generated
            AccountInformationAccessRequestAuthorizationMetaBuilder() {
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationMetaBuilder credentialsEncryptionKey(String credentialsEncryptionKey) {
                this.credentialsEncryptionKey = credentialsEncryptionKey;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestAuthorizationMeta build() {
                return new AccountInformationAccessRequestAuthorizationMeta(this.credentialsEncryptionKey);
            }

            @Generated
            public String toString() {
                return "AccountInformationAccessRequestAuthorizationsServiceImpl.AccountInformationAccessRequestAuthorizationMeta.AccountInformationAccessRequestAuthorizationMetaBuilder(credentialsEncryptionKey=" + this.credentialsEncryptionKey + ")";
            }
        }
    }
}

