/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequestMeta;
import com.ibanity.apis.client.products.xs2a.models.AuthorizationPortal;
import com.ibanity.apis.client.products.xs2a.models.create.AccountInformationAccessRequestCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.create.AuthorizationPortalCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.create.MetaRequestCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.links.AccountInformationAccessLinks;
import com.ibanity.apis.client.products.xs2a.models.links.AccountLinks;
import com.ibanity.apis.client.products.xs2a.models.links.InitialAccountTransactionsSynchronizationsLinks;
import com.ibanity.apis.client.products.xs2a.models.read.AccountInformationAccessRequestReadQuery;
import com.ibanity.apis.client.products.xs2a.services.AccountInformationAccessRequestsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountInformationAccessRequestsServiceImpl
implements AccountInformationAccessRequestsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountInformationAccessRequestsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest create(AccountInformationAccessRequestCreationQuery accountInformationAccessRequestCreationQuery) {
        String financialInstitutionId = accountInformationAccessRequestCreationQuery.getFinancialInstitutionId().toString();
        URI uri = this.getUri(financialInstitutionId, "");
        AccountInformationAccessRequest ibanityModel = this.mapAttributes(accountInformationAccessRequestCreationQuery);
        AccountInformationAccessRequestMeta meta = this.mapMeta(accountInformationAccessRequestCreationQuery);
        RequestApiModel request = ModelMapperHelper.buildRequest("accountInformationAccessRequest", ibanityModel, meta);
        HttpResponse response = this.ibanityHttpClient.post(uri, request, accountInformationAccessRequestCreationQuery.getAdditionalHeaders(), accountInformationAccessRequestCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    @Override
    @Deprecated
    public com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest find(AccountInformationAccessRequestCreationQuery accountInformationAccessRequestCreationQuery) {
        return this.find(AccountInformationAccessRequestReadQuery.builder().accountInformationAccessRequestId(accountInformationAccessRequestCreationQuery.getAccountInformationAccessRequestId()).financialInstitutionId(accountInformationAccessRequestCreationQuery.getFinancialInstitutionId()).customerAccessToken(accountInformationAccessRequestCreationQuery.getCustomerAccessToken()).additionalHeaders(accountInformationAccessRequestCreationQuery.getAdditionalHeaders()).build());
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest find(AccountInformationAccessRequestReadQuery accountInformationAccessRequestReadQuery) {
        String financialInstitutionId = accountInformationAccessRequestReadQuery.getFinancialInstitutionId().toString();
        String resourceId = accountInformationAccessRequestReadQuery.getAccountInformationAccessRequestId().toString();
        URI uri = this.getUri(financialInstitutionId, resourceId);
        HttpResponse response = this.ibanityHttpClient.get(uri, accountInformationAccessRequestReadQuery.getAdditionalHeaders(), accountInformationAccessRequestReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private URI getUri(String financialInstitutionId, String accountInformationAccessRequestId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "accountInformationAccessRequests");
        return URIHelper.buildUri(StringUtils.removeEnd((String)url.replace("{financialInstitutionId}", financialInstitutionId).replace("{accountInformationAccessRequestId}", accountInformationAccessRequestId), (String)"/"));
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest> responseMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest aiar = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.xs2a.models.AccountInformationAccessRequest.class);
            aiar.setAccountInformationAccessLinks(AccountInformationAccessLinks.builder().redirect(dataApiModel.getLinks() == null ? null : dataApiModel.getLinks().getRedirect()).build());
            if (dataApiModel.getRelationships() != null) {
                if (dataApiModel.getRelationships().get("accounts") != null && dataApiModel.getRelationships().get("accounts").getLinks() != null) {
                    aiar.setAccountLinks(AccountLinks.builder().related(dataApiModel.getRelationships().get("accounts").getLinks().getRelated()).build());
                }
                if (dataApiModel.getRelationships().get("initialAccountTransactionsSynchronizations") != null && dataApiModel.getRelationships().get("initialAccountTransactionsSynchronizations").getLinks() != null) {
                    aiar.setInitialAccountTransactionsSynchronizationsLinks(InitialAccountTransactionsSynchronizationsLinks.builder().related(dataApiModel.getRelationships().get("initialAccountTransactionsSynchronizations").getLinks().getRelated()).build());
                }
            }
            return aiar;
        };
    }

    private AccountInformationAccessRequest mapAttributes(AccountInformationAccessRequestCreationQuery creationQuery) {
        List<String> allowedAccountSubtypes = creationQuery.getAllowedAccountSubtypes();
        return AccountInformationAccessRequest.builder().redirectUri(creationQuery.getRedirectUri()).consentReference(creationQuery.getConsentReference()).requestedAccountReferences(creationQuery.getRequestedAccountReferences()).locale(creationQuery.getLocale()).customerIpAddress(creationQuery.getCustomerIpAddress()).allowFinancialInstitutionRedirectUri(creationQuery.isAllowFinancialInstitutionRedirectUri()).allowedAccountSubtypes(allowedAccountSubtypes.isEmpty() ? null : allowedAccountSubtypes).skipIbanityCompletionCallback(creationQuery.isSkipIbanityCompletionCallback()).allowMulticurrencyAccounts(creationQuery.isAllowMulticurrencyAccounts()).state(creationQuery.getState()).financialInstitutionCustomerReference(creationQuery.getFinancialInstitutionCustomerReference()).build();
    }

    private AccountInformationAccessRequestMeta mapMeta(AccountInformationAccessRequestCreationQuery creationQuery) {
        MetaRequestCreationQuery metaRequestCreationQuery = creationQuery.getMetaRequestCreationQuery();
        if (metaRequestCreationQuery == null) {
            return null;
        }
        AuthorizationPortalCreationQuery authorizationPortalCreationQuery = metaRequestCreationQuery.getAuthorizationPortalCreationQuery();
        AuthorizationPortal authorizationPortal = metaRequestCreationQuery.getAuthorizationPortalCreationQuery() == null ? null : AuthorizationPortal.builder().disclaimerContent(authorizationPortalCreationQuery.getDisclaimerContent()).disclaimerTitle(authorizationPortalCreationQuery.getDisclaimerTitle()).financialInstitutionPrimaryColor(authorizationPortalCreationQuery.getFinancialInstitutionPrimaryColor()).financialInstitutionSecondaryColor(authorizationPortalCreationQuery.getFinancialInstitutionSecondaryColor()).build();
        return AccountInformationAccessRequestMeta.builder().requestedPastTransactionDays(metaRequestCreationQuery.getRequestedPastTransactionDays()).authorizationPortal(authorizationPortal).build();
    }

    static class AccountInformationAccessRequest
    implements IbanityModel {
        public static final String RESOURCE_TYPE = "accountInformationAccessRequest";
        public static final String API_URL_TAG_ID = "{accountInformationAccessRequestId}";
        private UUID id;
        private String selfLink;
        private String requestId;
        private String consentReference;
        private String redirectUri;
        private String status;
        private String locale;
        private String customerIpAddress;
        private boolean allowFinancialInstitutionRedirectUri;
        private boolean skipIbanityCompletionCallback;
        private boolean allowMulticurrencyAccounts;
        private String state;
        private String financialInstitutionCustomerReference;
        private List<String> requestedAccountReferences;
        private List<String> allowedAccountSubtypes;

        @Generated
        private static List<String> $default$requestedAccountReferences() {
            return Collections.emptyList();
        }

        @Generated
        private static List<String> $default$allowedAccountSubtypes() {
            return Collections.emptyList();
        }

        @Generated
        public static AccountInformationAccessRequestBuilder builder() {
            return new AccountInformationAccessRequestBuilder();
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getSelfLink() {
            return this.selfLink;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getConsentReference() {
            return this.consentReference;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getLocale() {
            return this.locale;
        }

        @Generated
        public String getCustomerIpAddress() {
            return this.customerIpAddress;
        }

        @Generated
        public boolean isAllowFinancialInstitutionRedirectUri() {
            return this.allowFinancialInstitutionRedirectUri;
        }

        @Generated
        public boolean isSkipIbanityCompletionCallback() {
            return this.skipIbanityCompletionCallback;
        }

        @Generated
        public boolean isAllowMulticurrencyAccounts() {
            return this.allowMulticurrencyAccounts;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getFinancialInstitutionCustomerReference() {
            return this.financialInstitutionCustomerReference;
        }

        @Generated
        public List<String> getRequestedAccountReferences() {
            return this.requestedAccountReferences;
        }

        @Generated
        public List<String> getAllowedAccountSubtypes() {
            return this.allowedAccountSubtypes;
        }

        @Override
        @Generated
        public void setId(UUID id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setSelfLink(String selfLink) {
            this.selfLink = selfLink;
        }

        @Override
        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setConsentReference(String consentReference) {
            this.consentReference = consentReference;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Generated
        public void setCustomerIpAddress(String customerIpAddress) {
            this.customerIpAddress = customerIpAddress;
        }

        @Generated
        public void setAllowFinancialInstitutionRedirectUri(boolean allowFinancialInstitutionRedirectUri) {
            this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
        }

        @Generated
        public void setSkipIbanityCompletionCallback(boolean skipIbanityCompletionCallback) {
            this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
        }

        @Generated
        public void setAllowMulticurrencyAccounts(boolean allowMulticurrencyAccounts) {
            this.allowMulticurrencyAccounts = allowMulticurrencyAccounts;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setFinancialInstitutionCustomerReference(String financialInstitutionCustomerReference) {
            this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
        }

        @Generated
        public void setRequestedAccountReferences(List<String> requestedAccountReferences) {
            this.requestedAccountReferences = requestedAccountReferences;
        }

        @Generated
        public void setAllowedAccountSubtypes(List<String> allowedAccountSubtypes) {
            this.allowedAccountSubtypes = allowedAccountSubtypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountInformationAccessRequest)) {
                return false;
            }
            AccountInformationAccessRequest other = (AccountInformationAccessRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAllowFinancialInstitutionRedirectUri() != other.isAllowFinancialInstitutionRedirectUri()) {
                return false;
            }
            if (this.isSkipIbanityCompletionCallback() != other.isSkipIbanityCompletionCallback()) {
                return false;
            }
            if (this.isAllowMulticurrencyAccounts() != other.isAllowMulticurrencyAccounts()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$selfLink = this.getSelfLink();
            String other$selfLink = other.getSelfLink();
            if (this$selfLink == null ? other$selfLink != null : !this$selfLink.equals(other$selfLink)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$consentReference = this.getConsentReference();
            String other$consentReference = other.getConsentReference();
            if (this$consentReference == null ? other$consentReference != null : !this$consentReference.equals(other$consentReference)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$customerIpAddress = this.getCustomerIpAddress();
            String other$customerIpAddress = other.getCustomerIpAddress();
            if (this$customerIpAddress == null ? other$customerIpAddress != null : !this$customerIpAddress.equals(other$customerIpAddress)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$financialInstitutionCustomerReference = this.getFinancialInstitutionCustomerReference();
            String other$financialInstitutionCustomerReference = other.getFinancialInstitutionCustomerReference();
            if (this$financialInstitutionCustomerReference == null ? other$financialInstitutionCustomerReference != null : !this$financialInstitutionCustomerReference.equals(other$financialInstitutionCustomerReference)) {
                return false;
            }
            List<String> this$requestedAccountReferences = this.getRequestedAccountReferences();
            List<String> other$requestedAccountReferences = other.getRequestedAccountReferences();
            if (this$requestedAccountReferences == null ? other$requestedAccountReferences != null : !((Object)this$requestedAccountReferences).equals(other$requestedAccountReferences)) {
                return false;
            }
            List<String> this$allowedAccountSubtypes = this.getAllowedAccountSubtypes();
            List<String> other$allowedAccountSubtypes = other.getAllowedAccountSubtypes();
            return !(this$allowedAccountSubtypes == null ? other$allowedAccountSubtypes != null : !((Object)this$allowedAccountSubtypes).equals(other$allowedAccountSubtypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountInformationAccessRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowFinancialInstitutionRedirectUri() ? 79 : 97);
            result = result * 59 + (this.isSkipIbanityCompletionCallback() ? 79 : 97);
            result = result * 59 + (this.isAllowMulticurrencyAccounts() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $selfLink = this.getSelfLink();
            result = result * 59 + ($selfLink == null ? 43 : $selfLink.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $consentReference = this.getConsentReference();
            result = result * 59 + ($consentReference == null ? 43 : $consentReference.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $customerIpAddress = this.getCustomerIpAddress();
            result = result * 59 + ($customerIpAddress == null ? 43 : $customerIpAddress.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $financialInstitutionCustomerReference = this.getFinancialInstitutionCustomerReference();
            result = result * 59 + ($financialInstitutionCustomerReference == null ? 43 : $financialInstitutionCustomerReference.hashCode());
            List<String> $requestedAccountReferences = this.getRequestedAccountReferences();
            result = result * 59 + ($requestedAccountReferences == null ? 43 : ((Object)$requestedAccountReferences).hashCode());
            List<String> $allowedAccountSubtypes = this.getAllowedAccountSubtypes();
            result = result * 59 + ($allowedAccountSubtypes == null ? 43 : ((Object)$allowedAccountSubtypes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountInformationAccessRequestsServiceImpl.AccountInformationAccessRequest(id=" + this.getId() + ", selfLink=" + this.getSelfLink() + ", requestId=" + this.getRequestId() + ", consentReference=" + this.getConsentReference() + ", redirectUri=" + this.getRedirectUri() + ", status=" + this.getStatus() + ", locale=" + this.getLocale() + ", customerIpAddress=" + this.getCustomerIpAddress() + ", allowFinancialInstitutionRedirectUri=" + this.isAllowFinancialInstitutionRedirectUri() + ", skipIbanityCompletionCallback=" + this.isSkipIbanityCompletionCallback() + ", allowMulticurrencyAccounts=" + this.isAllowMulticurrencyAccounts() + ", state=" + this.getState() + ", financialInstitutionCustomerReference=" + this.getFinancialInstitutionCustomerReference() + ", requestedAccountReferences=" + this.getRequestedAccountReferences() + ", allowedAccountSubtypes=" + this.getAllowedAccountSubtypes() + ")";
        }

        @Generated
        public AccountInformationAccessRequest() {
            this.requestedAccountReferences = AccountInformationAccessRequest.$default$requestedAccountReferences();
            this.allowedAccountSubtypes = AccountInformationAccessRequest.$default$allowedAccountSubtypes();
        }

        @Generated
        private AccountInformationAccessRequest(UUID id, String selfLink, String requestId, String consentReference, String redirectUri, String status, String locale, String customerIpAddress, boolean allowFinancialInstitutionRedirectUri, boolean skipIbanityCompletionCallback, boolean allowMulticurrencyAccounts, String state, String financialInstitutionCustomerReference, List<String> requestedAccountReferences, List<String> allowedAccountSubtypes) {
            this.id = id;
            this.selfLink = selfLink;
            this.requestId = requestId;
            this.consentReference = consentReference;
            this.redirectUri = redirectUri;
            this.status = status;
            this.locale = locale;
            this.customerIpAddress = customerIpAddress;
            this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
            this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
            this.allowMulticurrencyAccounts = allowMulticurrencyAccounts;
            this.state = state;
            this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
            this.requestedAccountReferences = requestedAccountReferences;
            this.allowedAccountSubtypes = allowedAccountSubtypes;
        }

        @Generated
        public static class AccountInformationAccessRequestBuilder {
            @Generated
            private UUID id;
            @Generated
            private String selfLink;
            @Generated
            private String requestId;
            @Generated
            private String consentReference;
            @Generated
            private String redirectUri;
            @Generated
            private String status;
            @Generated
            private String locale;
            @Generated
            private String customerIpAddress;
            @Generated
            private boolean allowFinancialInstitutionRedirectUri;
            @Generated
            private boolean skipIbanityCompletionCallback;
            @Generated
            private boolean allowMulticurrencyAccounts;
            @Generated
            private String state;
            @Generated
            private String financialInstitutionCustomerReference;
            @Generated
            private boolean requestedAccountReferences$set;
            @Generated
            private List<String> requestedAccountReferences$value;
            @Generated
            private boolean allowedAccountSubtypes$set;
            @Generated
            private List<String> allowedAccountSubtypes$value;

            @Generated
            AccountInformationAccessRequestBuilder() {
            }

            @Generated
            public AccountInformationAccessRequestBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder selfLink(String selfLink) {
                this.selfLink = selfLink;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder consentReference(String consentReference) {
                this.consentReference = consentReference;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder status(String status) {
                this.status = status;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder locale(String locale) {
                this.locale = locale;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder customerIpAddress(String customerIpAddress) {
                this.customerIpAddress = customerIpAddress;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder allowFinancialInstitutionRedirectUri(boolean allowFinancialInstitutionRedirectUri) {
                this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder skipIbanityCompletionCallback(boolean skipIbanityCompletionCallback) {
                this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder allowMulticurrencyAccounts(boolean allowMulticurrencyAccounts) {
                this.allowMulticurrencyAccounts = allowMulticurrencyAccounts;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder state(String state) {
                this.state = state;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder financialInstitutionCustomerReference(String financialInstitutionCustomerReference) {
                this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder requestedAccountReferences(List<String> requestedAccountReferences) {
                this.requestedAccountReferences$value = requestedAccountReferences;
                this.requestedAccountReferences$set = true;
                return this;
            }

            @Generated
            public AccountInformationAccessRequestBuilder allowedAccountSubtypes(List<String> allowedAccountSubtypes) {
                this.allowedAccountSubtypes$value = allowedAccountSubtypes;
                this.allowedAccountSubtypes$set = true;
                return this;
            }

            @Generated
            public AccountInformationAccessRequest build() {
                List requestedAccountReferences$value = this.requestedAccountReferences$value;
                if (!this.requestedAccountReferences$set) {
                    requestedAccountReferences$value = AccountInformationAccessRequest.$default$requestedAccountReferences();
                }
                List allowedAccountSubtypes$value = this.allowedAccountSubtypes$value;
                if (!this.allowedAccountSubtypes$set) {
                    allowedAccountSubtypes$value = AccountInformationAccessRequest.$default$allowedAccountSubtypes();
                }
                return new AccountInformationAccessRequest(this.id, this.selfLink, this.requestId, this.consentReference, this.redirectUri, this.status, this.locale, this.customerIpAddress, this.allowFinancialInstitutionRedirectUri, this.skipIbanityCompletionCallback, this.allowMulticurrencyAccounts, this.state, this.financialInstitutionCustomerReference, requestedAccountReferences$value, allowedAccountSubtypes$value);
            }

            @Generated
            public String toString() {
                return "AccountInformationAccessRequestsServiceImpl.AccountInformationAccessRequest.AccountInformationAccessRequestBuilder(id=" + this.id + ", selfLink=" + this.selfLink + ", requestId=" + this.requestId + ", consentReference=" + this.consentReference + ", redirectUri=" + this.redirectUri + ", status=" + this.status + ", locale=" + this.locale + ", customerIpAddress=" + this.customerIpAddress + ", allowFinancialInstitutionRedirectUri=" + this.allowFinancialInstitutionRedirectUri + ", skipIbanityCompletionCallback=" + this.skipIbanityCompletionCallback + ", allowMulticurrencyAccounts=" + this.allowMulticurrencyAccounts + ", state=" + this.state + ", financialInstitutionCustomerReference=" + this.financialInstitutionCustomerReference + ", requestedAccountReferences$value=" + this.requestedAccountReferences$value + ", allowedAccountSubtypes$value=" + this.allowedAccountSubtypes$value + ")";
            }
        }
    }
}

