/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.mappers.SynchronizationMapper;
import com.ibanity.apis.client.products.xs2a.models.Account;
import com.ibanity.apis.client.products.xs2a.models.Synchronization;
import com.ibanity.apis.client.products.xs2a.models.delete.AccountDeleteQuery;
import com.ibanity.apis.client.products.xs2a.models.read.AccountReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.AccountsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.AccountsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountsServiceImpl
implements AccountsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Account find(AccountReadQuery accountReadQuery) {
        String url = this.getUrl(accountReadQuery.getFinancialInstitutionId(), null) + "/" + accountReadQuery.getAccountId();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), accountReadQuery.getAdditionalHeaders(), accountReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMappingFunction());
    }

    @Override
    public IbanityCollection<Account> list(AccountsReadQuery accountsReadQuery) {
        IbanityPagingSpec pagingSpec = accountsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrl(accountsReadQuery.getFinancialInstitutionId(), accountsReadQuery.getAccountInformationAccessRequestId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), accountsReadQuery.getAdditionalHeaders(), accountsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, this.customMappingFunction());
    }

    @Override
    public Account delete(AccountDeleteQuery accountDeleteQuery) {
        String url = this.getUrl(accountDeleteQuery.getFinancialInstitutionId(), null) + "/" + accountDeleteQuery.getAccountId();
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url), accountDeleteQuery.getAdditionalHeaders(), accountDeleteQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMappingFunction());
    }

    private Function<DataApiModel, Account> customMappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel financialInstitution;
            Account account = IbanityModelMapper.toIbanityModel(dataApiModel, Account.class);
            if (dataApiModel.getMeta() != null) {
                Synchronization synchronization = SynchronizationMapper.map(dataApiModel.getMeta().getLatestSynchronization());
                account.setLatestSynchronization(synchronization);
                account.setAvailability(dataApiModel.getMeta().getAvailability());
                account.setSynchronizedAt(dataApiModel.getMeta().getSynchronizedAt());
            }
            if ((financialInstitution = dataApiModel.getRelationships().get("financialInstitution")) != null) {
                account.setFinancialInstitutionId(UUID.fromString(financialInstitution.getData().getId()));
            }
            return account;
        };
    }

    private String getUrl(UUID financialInstitutionId, UUID accountInformationAccessRequestId) {
        String url = accountInformationAccessRequestId != null && financialInstitutionId != null ? this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "accountInformationAccessRequest", "accounts").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountInformationAccessRequestId}", accountInformationAccessRequestId.toString()).replace("{accountId}", "") : (financialInstitutionId != null ? this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "accounts").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountId}", "") : this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "accounts").replace("{accountId}", ""));
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

