/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.mappers.BatchSynchronizationMapper;
import com.ibanity.apis.client.products.xs2a.models.BatchSynchronization;
import com.ibanity.apis.client.products.xs2a.models.create.BatchSynchronizationCreationQuery;
import com.ibanity.apis.client.products.xs2a.services.BatchSynchronizationService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class BatchSynchronizationServiceImpl
implements BatchSynchronizationService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public BatchSynchronizationServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public BatchSynchronization create(BatchSynchronizationCreationQuery batchSynchronizationCreationQuery) {
        BatchSynchronization synchronization = BatchSynchronization.builder().resourceType(batchSynchronizationCreationQuery.getResourceType()).cancelAfter(batchSynchronizationCreationQuery.getCancelAfter()).unlessSynchronizedAfter(batchSynchronizationCreationQuery.getUnlessSynchronizedAfter()).resourceType(batchSynchronizationCreationQuery.getResourceType()).subtypes(batchSynchronizationCreationQuery.getSubtypes()).build();
        String url = this.getUrl();
        RequestApiModel request = ModelMapperHelper.buildRequest("synchronization", synchronization);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, batchSynchronizationCreationQuery.getAdditionalHeaders(), null);
        return IbanityModelMapper.mapResource(response, BatchSynchronizationMapper::map);
    }

    private String getUrl() {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "batchSynchronizations");
        return StringUtils.removeEnd((String)url.replace("{batchSynchronizationId}", ""), (String)"/");
    }
}

