/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.mappers.BulkPaymentInitiationRequestMapper;
import com.ibanity.apis.client.products.xs2a.models.create.BulkPaymentInitiationRequestCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.read.BulkPaymentInitiationRequestReadQuery;
import com.ibanity.apis.client.products.xs2a.services.BulkPaymentInitiationRequestService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class BulkPaymentInitiationRequestServiceImpl
implements BulkPaymentInitiationRequestService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public BulkPaymentInitiationRequestServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.BulkPaymentInitiationRequest create(BulkPaymentInitiationRequestCreationQuery query) {
        BulkPaymentInitiationRequest bulkPaymentInitiationRequest = BulkPaymentInitiationRequestMapper.getRequestMapping(query);
        RequestApiModel request = ModelMapperHelper.buildRequest("bulkPaymentInitiationRequest", bulkPaymentInitiationRequest);
        String url = this.getUrl(query.getFinancialInstitutionId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, query.getAdditionalHeaders(), query.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, BulkPaymentInitiationRequestMapper.getResponseMapping());
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.BulkPaymentInitiationRequest delete(BulkPaymentInitiationRequestReadQuery bulkPaymentInitiationRequestReadQuery) {
        String financialInstitutionId = bulkPaymentInitiationRequestReadQuery.getFinancialInstitutionId().toString();
        String paymentInitiationRequestId = bulkPaymentInitiationRequestReadQuery.getPaymentInitiationRequestId().toString();
        String url = this.getUrl(financialInstitutionId, paymentInitiationRequestId);
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(url), bulkPaymentInitiationRequestReadQuery.getAdditionalHeaders(), bulkPaymentInitiationRequestReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, BulkPaymentInitiationRequestMapper.getResponseMapping());
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.BulkPaymentInitiationRequest find(BulkPaymentInitiationRequestReadQuery bulkPaymentInitiationRequestReadQuery) {
        String financialInstitutionId = bulkPaymentInitiationRequestReadQuery.getFinancialInstitutionId().toString();
        String paymentInitiationRequestId = bulkPaymentInitiationRequestReadQuery.getPaymentInitiationRequestId().toString();
        String url = this.getUrl(financialInstitutionId, paymentInitiationRequestId);
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), bulkPaymentInitiationRequestReadQuery.getAdditionalHeaders(), bulkPaymentInitiationRequestReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, BulkPaymentInitiationRequestMapper.getResponseMapping());
    }

    private String getUrl(String financialInstitutionId, String paymentInitiationRequestId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "bulkPaymentInitiationRequests").replace("{financialInstitutionId}", financialInstitutionId).replace("{paymentInitiationRequestId}", paymentInitiationRequestId), (String)"/");
    }

    public static class BulkPaymentInitiationRequest
    implements IbanityModel {
        public static final String RESOURCE_TYPE = "bulkPaymentInitiationRequest";
        public static final String API_URL_TAG_ID = "{paymentInitiationRequestId}";
        private UUID id;
        private UUID financialInstitutionId;
        private String selfLink;
        private String requestId;
        private String consentReference;
        private String productType;
        private String debtorName;
        private String debtorAccountReference;
        private String debtorAccountReferenceType;
        private String status;
        private String statusReason;
        private String redirectUri;
        private String locale;
        private String customerIpAddress;
        private boolean allowFinancialInstitutionRedirectUri;
        private boolean skipIbanityCompletionCallback;
        private boolean batchBookingPreferred;
        private String state;
        private String financialInstitutionCustomerReference;
        private LocalDate requestedExecutionDate;
        private List<Payment> payments;

        @Generated
        private static List<Payment> $default$payments() {
            return Collections.emptyList();
        }

        @Generated
        public static BulkPaymentInitiationRequestBuilder builder() {
            return new BulkPaymentInitiationRequestBuilder();
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public UUID getFinancialInstitutionId() {
            return this.financialInstitutionId;
        }

        @Generated
        public String getSelfLink() {
            return this.selfLink;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getConsentReference() {
            return this.consentReference;
        }

        @Generated
        public String getProductType() {
            return this.productType;
        }

        @Generated
        public String getDebtorName() {
            return this.debtorName;
        }

        @Generated
        public String getDebtorAccountReference() {
            return this.debtorAccountReference;
        }

        @Generated
        public String getDebtorAccountReferenceType() {
            return this.debtorAccountReferenceType;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getStatusReason() {
            return this.statusReason;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public String getLocale() {
            return this.locale;
        }

        @Generated
        public String getCustomerIpAddress() {
            return this.customerIpAddress;
        }

        @Generated
        public boolean isAllowFinancialInstitutionRedirectUri() {
            return this.allowFinancialInstitutionRedirectUri;
        }

        @Generated
        public boolean isSkipIbanityCompletionCallback() {
            return this.skipIbanityCompletionCallback;
        }

        @Generated
        public boolean isBatchBookingPreferred() {
            return this.batchBookingPreferred;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getFinancialInstitutionCustomerReference() {
            return this.financialInstitutionCustomerReference;
        }

        @Generated
        public LocalDate getRequestedExecutionDate() {
            return this.requestedExecutionDate;
        }

        @Generated
        public List<Payment> getPayments() {
            return this.payments;
        }

        @Override
        @Generated
        public void setId(UUID id) {
            this.id = id;
        }

        @Generated
        public void setFinancialInstitutionId(UUID financialInstitutionId) {
            this.financialInstitutionId = financialInstitutionId;
        }

        @Override
        @Generated
        public void setSelfLink(String selfLink) {
            this.selfLink = selfLink;
        }

        @Override
        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setConsentReference(String consentReference) {
            this.consentReference = consentReference;
        }

        @Generated
        public void setProductType(String productType) {
            this.productType = productType;
        }

        @Generated
        public void setDebtorName(String debtorName) {
            this.debtorName = debtorName;
        }

        @Generated
        public void setDebtorAccountReference(String debtorAccountReference) {
            this.debtorAccountReference = debtorAccountReference;
        }

        @Generated
        public void setDebtorAccountReferenceType(String debtorAccountReferenceType) {
            this.debtorAccountReferenceType = debtorAccountReferenceType;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Generated
        public void setCustomerIpAddress(String customerIpAddress) {
            this.customerIpAddress = customerIpAddress;
        }

        @Generated
        public void setAllowFinancialInstitutionRedirectUri(boolean allowFinancialInstitutionRedirectUri) {
            this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
        }

        @Generated
        public void setSkipIbanityCompletionCallback(boolean skipIbanityCompletionCallback) {
            this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
        }

        @Generated
        public void setBatchBookingPreferred(boolean batchBookingPreferred) {
            this.batchBookingPreferred = batchBookingPreferred;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setFinancialInstitutionCustomerReference(String financialInstitutionCustomerReference) {
            this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
        }

        @Generated
        public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
            this.requestedExecutionDate = requestedExecutionDate;
        }

        @Generated
        public void setPayments(List<Payment> payments) {
            this.payments = payments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkPaymentInitiationRequest)) {
                return false;
            }
            BulkPaymentInitiationRequest other = (BulkPaymentInitiationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAllowFinancialInstitutionRedirectUri() != other.isAllowFinancialInstitutionRedirectUri()) {
                return false;
            }
            if (this.isSkipIbanityCompletionCallback() != other.isSkipIbanityCompletionCallback()) {
                return false;
            }
            if (this.isBatchBookingPreferred() != other.isBatchBookingPreferred()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            UUID this$financialInstitutionId = this.getFinancialInstitutionId();
            UUID other$financialInstitutionId = other.getFinancialInstitutionId();
            if (this$financialInstitutionId == null ? other$financialInstitutionId != null : !((Object)this$financialInstitutionId).equals(other$financialInstitutionId)) {
                return false;
            }
            String this$selfLink = this.getSelfLink();
            String other$selfLink = other.getSelfLink();
            if (this$selfLink == null ? other$selfLink != null : !this$selfLink.equals(other$selfLink)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$consentReference = this.getConsentReference();
            String other$consentReference = other.getConsentReference();
            if (this$consentReference == null ? other$consentReference != null : !this$consentReference.equals(other$consentReference)) {
                return false;
            }
            String this$productType = this.getProductType();
            String other$productType = other.getProductType();
            if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
                return false;
            }
            String this$debtorName = this.getDebtorName();
            String other$debtorName = other.getDebtorName();
            if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
                return false;
            }
            String this$debtorAccountReference = this.getDebtorAccountReference();
            String other$debtorAccountReference = other.getDebtorAccountReference();
            if (this$debtorAccountReference == null ? other$debtorAccountReference != null : !this$debtorAccountReference.equals(other$debtorAccountReference)) {
                return false;
            }
            String this$debtorAccountReferenceType = this.getDebtorAccountReferenceType();
            String other$debtorAccountReferenceType = other.getDebtorAccountReferenceType();
            if (this$debtorAccountReferenceType == null ? other$debtorAccountReferenceType != null : !this$debtorAccountReferenceType.equals(other$debtorAccountReferenceType)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$statusReason = this.getStatusReason();
            String other$statusReason = other.getStatusReason();
            if (this$statusReason == null ? other$statusReason != null : !this$statusReason.equals(other$statusReason)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$customerIpAddress = this.getCustomerIpAddress();
            String other$customerIpAddress = other.getCustomerIpAddress();
            if (this$customerIpAddress == null ? other$customerIpAddress != null : !this$customerIpAddress.equals(other$customerIpAddress)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$financialInstitutionCustomerReference = this.getFinancialInstitutionCustomerReference();
            String other$financialInstitutionCustomerReference = other.getFinancialInstitutionCustomerReference();
            if (this$financialInstitutionCustomerReference == null ? other$financialInstitutionCustomerReference != null : !this$financialInstitutionCustomerReference.equals(other$financialInstitutionCustomerReference)) {
                return false;
            }
            LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
            LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
            if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
                return false;
            }
            List<Payment> this$payments = this.getPayments();
            List<Payment> other$payments = other.getPayments();
            return !(this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkPaymentInitiationRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowFinancialInstitutionRedirectUri() ? 79 : 97);
            result = result * 59 + (this.isSkipIbanityCompletionCallback() ? 79 : 97);
            result = result * 59 + (this.isBatchBookingPreferred() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            UUID $financialInstitutionId = this.getFinancialInstitutionId();
            result = result * 59 + ($financialInstitutionId == null ? 43 : ((Object)$financialInstitutionId).hashCode());
            String $selfLink = this.getSelfLink();
            result = result * 59 + ($selfLink == null ? 43 : $selfLink.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $consentReference = this.getConsentReference();
            result = result * 59 + ($consentReference == null ? 43 : $consentReference.hashCode());
            String $productType = this.getProductType();
            result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
            String $debtorName = this.getDebtorName();
            result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
            String $debtorAccountReference = this.getDebtorAccountReference();
            result = result * 59 + ($debtorAccountReference == null ? 43 : $debtorAccountReference.hashCode());
            String $debtorAccountReferenceType = this.getDebtorAccountReferenceType();
            result = result * 59 + ($debtorAccountReferenceType == null ? 43 : $debtorAccountReferenceType.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $statusReason = this.getStatusReason();
            result = result * 59 + ($statusReason == null ? 43 : $statusReason.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $customerIpAddress = this.getCustomerIpAddress();
            result = result * 59 + ($customerIpAddress == null ? 43 : $customerIpAddress.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $financialInstitutionCustomerReference = this.getFinancialInstitutionCustomerReference();
            result = result * 59 + ($financialInstitutionCustomerReference == null ? 43 : $financialInstitutionCustomerReference.hashCode());
            LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
            result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
            List<Payment> $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BulkPaymentInitiationRequestServiceImpl.BulkPaymentInitiationRequest(id=" + this.getId() + ", financialInstitutionId=" + this.getFinancialInstitutionId() + ", selfLink=" + this.getSelfLink() + ", requestId=" + this.getRequestId() + ", consentReference=" + this.getConsentReference() + ", productType=" + this.getProductType() + ", debtorName=" + this.getDebtorName() + ", debtorAccountReference=" + this.getDebtorAccountReference() + ", debtorAccountReferenceType=" + this.getDebtorAccountReferenceType() + ", status=" + this.getStatus() + ", statusReason=" + this.getStatusReason() + ", redirectUri=" + this.getRedirectUri() + ", locale=" + this.getLocale() + ", customerIpAddress=" + this.getCustomerIpAddress() + ", allowFinancialInstitutionRedirectUri=" + this.isAllowFinancialInstitutionRedirectUri() + ", skipIbanityCompletionCallback=" + this.isSkipIbanityCompletionCallback() + ", batchBookingPreferred=" + this.isBatchBookingPreferred() + ", state=" + this.getState() + ", financialInstitutionCustomerReference=" + this.getFinancialInstitutionCustomerReference() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", payments=" + this.getPayments() + ")";
        }

        @Generated
        public BulkPaymentInitiationRequest() {
            this.payments = BulkPaymentInitiationRequest.$default$payments();
        }

        @Generated
        private BulkPaymentInitiationRequest(UUID id, UUID financialInstitutionId, String selfLink, String requestId, String consentReference, String productType, String debtorName, String debtorAccountReference, String debtorAccountReferenceType, String status, String statusReason, String redirectUri, String locale, String customerIpAddress, boolean allowFinancialInstitutionRedirectUri, boolean skipIbanityCompletionCallback, boolean batchBookingPreferred, String state, String financialInstitutionCustomerReference, LocalDate requestedExecutionDate, List<Payment> payments) {
            this.id = id;
            this.financialInstitutionId = financialInstitutionId;
            this.selfLink = selfLink;
            this.requestId = requestId;
            this.consentReference = consentReference;
            this.productType = productType;
            this.debtorName = debtorName;
            this.debtorAccountReference = debtorAccountReference;
            this.debtorAccountReferenceType = debtorAccountReferenceType;
            this.status = status;
            this.statusReason = statusReason;
            this.redirectUri = redirectUri;
            this.locale = locale;
            this.customerIpAddress = customerIpAddress;
            this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
            this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
            this.batchBookingPreferred = batchBookingPreferred;
            this.state = state;
            this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
            this.requestedExecutionDate = requestedExecutionDate;
            this.payments = payments;
        }

        @Generated
        public static class BulkPaymentInitiationRequestBuilder {
            @Generated
            private UUID id;
            @Generated
            private UUID financialInstitutionId;
            @Generated
            private String selfLink;
            @Generated
            private String requestId;
            @Generated
            private String consentReference;
            @Generated
            private String productType;
            @Generated
            private String debtorName;
            @Generated
            private String debtorAccountReference;
            @Generated
            private String debtorAccountReferenceType;
            @Generated
            private String status;
            @Generated
            private String statusReason;
            @Generated
            private String redirectUri;
            @Generated
            private String locale;
            @Generated
            private String customerIpAddress;
            @Generated
            private boolean allowFinancialInstitutionRedirectUri;
            @Generated
            private boolean skipIbanityCompletionCallback;
            @Generated
            private boolean batchBookingPreferred;
            @Generated
            private String state;
            @Generated
            private String financialInstitutionCustomerReference;
            @Generated
            private LocalDate requestedExecutionDate;
            @Generated
            private boolean payments$set;
            @Generated
            private List<Payment> payments$value;

            @Generated
            BulkPaymentInitiationRequestBuilder() {
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder financialInstitutionId(UUID financialInstitutionId) {
                this.financialInstitutionId = financialInstitutionId;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder selfLink(String selfLink) {
                this.selfLink = selfLink;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder consentReference(String consentReference) {
                this.consentReference = consentReference;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder productType(String productType) {
                this.productType = productType;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder debtorName(String debtorName) {
                this.debtorName = debtorName;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder debtorAccountReference(String debtorAccountReference) {
                this.debtorAccountReference = debtorAccountReference;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder debtorAccountReferenceType(String debtorAccountReferenceType) {
                this.debtorAccountReferenceType = debtorAccountReferenceType;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder status(String status) {
                this.status = status;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder statusReason(String statusReason) {
                this.statusReason = statusReason;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder locale(String locale) {
                this.locale = locale;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder customerIpAddress(String customerIpAddress) {
                this.customerIpAddress = customerIpAddress;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder allowFinancialInstitutionRedirectUri(boolean allowFinancialInstitutionRedirectUri) {
                this.allowFinancialInstitutionRedirectUri = allowFinancialInstitutionRedirectUri;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder skipIbanityCompletionCallback(boolean skipIbanityCompletionCallback) {
                this.skipIbanityCompletionCallback = skipIbanityCompletionCallback;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder batchBookingPreferred(boolean batchBookingPreferred) {
                this.batchBookingPreferred = batchBookingPreferred;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder state(String state) {
                this.state = state;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder financialInstitutionCustomerReference(String financialInstitutionCustomerReference) {
                this.financialInstitutionCustomerReference = financialInstitutionCustomerReference;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder requestedExecutionDate(LocalDate requestedExecutionDate) {
                this.requestedExecutionDate = requestedExecutionDate;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequestBuilder payments(List<Payment> payments) {
                this.payments$value = payments;
                this.payments$set = true;
                return this;
            }

            @Generated
            public BulkPaymentInitiationRequest build() {
                List payments$value = this.payments$value;
                if (!this.payments$set) {
                    payments$value = BulkPaymentInitiationRequest.$default$payments();
                }
                return new BulkPaymentInitiationRequest(this.id, this.financialInstitutionId, this.selfLink, this.requestId, this.consentReference, this.productType, this.debtorName, this.debtorAccountReference, this.debtorAccountReferenceType, this.status, this.statusReason, this.redirectUri, this.locale, this.customerIpAddress, this.allowFinancialInstitutionRedirectUri, this.skipIbanityCompletionCallback, this.batchBookingPreferred, this.state, this.financialInstitutionCustomerReference, this.requestedExecutionDate, payments$value);
            }

            @Generated
            public String toString() {
                return "BulkPaymentInitiationRequestServiceImpl.BulkPaymentInitiationRequest.BulkPaymentInitiationRequestBuilder(id=" + this.id + ", financialInstitutionId=" + this.financialInstitutionId + ", selfLink=" + this.selfLink + ", requestId=" + this.requestId + ", consentReference=" + this.consentReference + ", productType=" + this.productType + ", debtorName=" + this.debtorName + ", debtorAccountReference=" + this.debtorAccountReference + ", debtorAccountReferenceType=" + this.debtorAccountReferenceType + ", status=" + this.status + ", statusReason=" + this.statusReason + ", redirectUri=" + this.redirectUri + ", locale=" + this.locale + ", customerIpAddress=" + this.customerIpAddress + ", allowFinancialInstitutionRedirectUri=" + this.allowFinancialInstitutionRedirectUri + ", skipIbanityCompletionCallback=" + this.skipIbanityCompletionCallback + ", batchBookingPreferred=" + this.batchBookingPreferred + ", state=" + this.state + ", financialInstitutionCustomerReference=" + this.financialInstitutionCustomerReference + ", requestedExecutionDate=" + this.requestedExecutionDate + ", payments$value=" + this.payments$value + ")";
            }
        }

        public static class Payment {
            private String endToEndId;
            private String remittanceInformationType;
            private String remittanceInformation;
            private BigDecimal amount;
            private String currency;
            private String creditorName;
            private String creditorAccountReference;
            private String creditorAccountReferenceType;
            private String creditorAgent;
            private String creditorAgentType;

            @Generated
            Payment(String endToEndId, String remittanceInformationType, String remittanceInformation, BigDecimal amount, String currency, String creditorName, String creditorAccountReference, String creditorAccountReferenceType, String creditorAgent, String creditorAgentType) {
                this.endToEndId = endToEndId;
                this.remittanceInformationType = remittanceInformationType;
                this.remittanceInformation = remittanceInformation;
                this.amount = amount;
                this.currency = currency;
                this.creditorName = creditorName;
                this.creditorAccountReference = creditorAccountReference;
                this.creditorAccountReferenceType = creditorAccountReferenceType;
                this.creditorAgent = creditorAgent;
                this.creditorAgentType = creditorAgentType;
            }

            @Generated
            public static PaymentBuilder builder() {
                return new PaymentBuilder();
            }

            @Generated
            public String getEndToEndId() {
                return this.endToEndId;
            }

            @Generated
            public String getRemittanceInformationType() {
                return this.remittanceInformationType;
            }

            @Generated
            public String getRemittanceInformation() {
                return this.remittanceInformation;
            }

            @Generated
            public BigDecimal getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public String getCreditorName() {
                return this.creditorName;
            }

            @Generated
            public String getCreditorAccountReference() {
                return this.creditorAccountReference;
            }

            @Generated
            public String getCreditorAccountReferenceType() {
                return this.creditorAccountReferenceType;
            }

            @Generated
            public String getCreditorAgent() {
                return this.creditorAgent;
            }

            @Generated
            public String getCreditorAgentType() {
                return this.creditorAgentType;
            }

            @Generated
            public String toString() {
                return "BulkPaymentInitiationRequestServiceImpl.BulkPaymentInitiationRequest.Payment(endToEndId=" + this.getEndToEndId() + ", remittanceInformationType=" + this.getRemittanceInformationType() + ", remittanceInformation=" + this.getRemittanceInformation() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", creditorName=" + this.getCreditorName() + ", creditorAccountReference=" + this.getCreditorAccountReference() + ", creditorAccountReferenceType=" + this.getCreditorAccountReferenceType() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorAgentType=" + this.getCreditorAgentType() + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payment)) {
                    return false;
                }
                Payment other = (Payment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$endToEndId = this.getEndToEndId();
                String other$endToEndId = other.getEndToEndId();
                if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
                    return false;
                }
                String this$remittanceInformationType = this.getRemittanceInformationType();
                String other$remittanceInformationType = other.getRemittanceInformationType();
                if (this$remittanceInformationType == null ? other$remittanceInformationType != null : !this$remittanceInformationType.equals(other$remittanceInformationType)) {
                    return false;
                }
                String this$remittanceInformation = this.getRemittanceInformation();
                String other$remittanceInformation = other.getRemittanceInformation();
                if (this$remittanceInformation == null ? other$remittanceInformation != null : !this$remittanceInformation.equals(other$remittanceInformation)) {
                    return false;
                }
                BigDecimal this$amount = this.getAmount();
                BigDecimal other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                String this$creditorName = this.getCreditorName();
                String other$creditorName = other.getCreditorName();
                if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
                    return false;
                }
                String this$creditorAccountReference = this.getCreditorAccountReference();
                String other$creditorAccountReference = other.getCreditorAccountReference();
                if (this$creditorAccountReference == null ? other$creditorAccountReference != null : !this$creditorAccountReference.equals(other$creditorAccountReference)) {
                    return false;
                }
                String this$creditorAccountReferenceType = this.getCreditorAccountReferenceType();
                String other$creditorAccountReferenceType = other.getCreditorAccountReferenceType();
                if (this$creditorAccountReferenceType == null ? other$creditorAccountReferenceType != null : !this$creditorAccountReferenceType.equals(other$creditorAccountReferenceType)) {
                    return false;
                }
                String this$creditorAgent = this.getCreditorAgent();
                String other$creditorAgent = other.getCreditorAgent();
                if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
                    return false;
                }
                String this$creditorAgentType = this.getCreditorAgentType();
                String other$creditorAgentType = other.getCreditorAgentType();
                return !(this$creditorAgentType == null ? other$creditorAgentType != null : !this$creditorAgentType.equals(other$creditorAgentType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $endToEndId = this.getEndToEndId();
                result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
                String $remittanceInformationType = this.getRemittanceInformationType();
                result = result * 59 + ($remittanceInformationType == null ? 43 : $remittanceInformationType.hashCode());
                String $remittanceInformation = this.getRemittanceInformation();
                result = result * 59 + ($remittanceInformation == null ? 43 : $remittanceInformation.hashCode());
                BigDecimal $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                String $creditorName = this.getCreditorName();
                result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
                String $creditorAccountReference = this.getCreditorAccountReference();
                result = result * 59 + ($creditorAccountReference == null ? 43 : $creditorAccountReference.hashCode());
                String $creditorAccountReferenceType = this.getCreditorAccountReferenceType();
                result = result * 59 + ($creditorAccountReferenceType == null ? 43 : $creditorAccountReferenceType.hashCode());
                String $creditorAgent = this.getCreditorAgent();
                result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
                String $creditorAgentType = this.getCreditorAgentType();
                result = result * 59 + ($creditorAgentType == null ? 43 : $creditorAgentType.hashCode());
                return result;
            }

            @Generated
            public static class PaymentBuilder {
                @Generated
                private String endToEndId;
                @Generated
                private String remittanceInformationType;
                @Generated
                private String remittanceInformation;
                @Generated
                private BigDecimal amount;
                @Generated
                private String currency;
                @Generated
                private String creditorName;
                @Generated
                private String creditorAccountReference;
                @Generated
                private String creditorAccountReferenceType;
                @Generated
                private String creditorAgent;
                @Generated
                private String creditorAgentType;

                @Generated
                PaymentBuilder() {
                }

                @Generated
                public PaymentBuilder endToEndId(String endToEndId) {
                    this.endToEndId = endToEndId;
                    return this;
                }

                @Generated
                public PaymentBuilder remittanceInformationType(String remittanceInformationType) {
                    this.remittanceInformationType = remittanceInformationType;
                    return this;
                }

                @Generated
                public PaymentBuilder remittanceInformation(String remittanceInformation) {
                    this.remittanceInformation = remittanceInformation;
                    return this;
                }

                @Generated
                public PaymentBuilder amount(BigDecimal amount) {
                    this.amount = amount;
                    return this;
                }

                @Generated
                public PaymentBuilder currency(String currency) {
                    this.currency = currency;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorName(String creditorName) {
                    this.creditorName = creditorName;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAccountReference(String creditorAccountReference) {
                    this.creditorAccountReference = creditorAccountReference;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAccountReferenceType(String creditorAccountReferenceType) {
                    this.creditorAccountReferenceType = creditorAccountReferenceType;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAgent(String creditorAgent) {
                    this.creditorAgent = creditorAgent;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAgentType(String creditorAgentType) {
                    this.creditorAgentType = creditorAgentType;
                    return this;
                }

                @Generated
                public Payment build() {
                    return new Payment(this.endToEndId, this.remittanceInformationType, this.remittanceInformation, this.amount, this.currency, this.creditorName, this.creditorAccountReference, this.creditorAccountReferenceType, this.creditorAgent, this.creditorAgentType);
                }

                @Generated
                public String toString() {
                    return "BulkPaymentInitiationRequestServiceImpl.BulkPaymentInitiationRequest.Payment.PaymentBuilder(endToEndId=" + this.endToEndId + ", remittanceInformationType=" + this.remittanceInformationType + ", remittanceInformation=" + this.remittanceInformation + ", amount=" + this.amount + ", currency=" + this.currency + ", creditorName=" + this.creditorName + ", creditorAccountReference=" + this.creditorAccountReference + ", creditorAccountReferenceType=" + this.creditorAccountReferenceType + ", creditorAgent=" + this.creditorAgent + ", creditorAgentType=" + this.creditorAgentType + ")";
                }
            }
        }
    }
}

