/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.CustomerAccessToken;
import com.ibanity.apis.client.products.xs2a.models.create.CustomerAccessTokenCreationQuery;
import com.ibanity.apis.client.products.xs2a.services.CustomerAccessTokensService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.http.HttpResponse;

public class CustomerAccessTokensServiceImpl
implements CustomerAccessTokensService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public CustomerAccessTokensServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public CustomerAccessToken create(CustomerAccessTokenCreationQuery customerAccessTokenCreationQuery) {
        CustomerAccessToken customerAccessToken = CustomerAccessToken.builder().applicationCustomerReference(customerAccessTokenCreationQuery.getApplicationCustomerReference()).build();
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customerAccessTokens");
        RequestApiModel request = ModelMapperHelper.buildRequest("customerAccessToken", customerAccessToken);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, customerAccessTokenCreationQuery.getAdditionalHeaders(), null);
        return IbanityModelMapper.mapResource(response, CustomerAccessToken.class);
    }
}

