/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.CollectionApiModel;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.Collection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.models.FinancialInstitutionCountry;
import com.ibanity.apis.client.products.xs2a.models.read.FinancialInstitutionCountriesReadQuery;
import com.ibanity.apis.client.products.xs2a.services.FinancialInstitutionCountriesService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class FinancialInstitutionCountriesServiceImpl
implements FinancialInstitutionCountriesService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionCountriesServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Collection<FinancialInstitutionCountry> list(FinancialInstitutionCountriesReadQuery financialInstitutionCountriesReadQuery) {
        IbanityPagingSpec pagingSpec = financialInstitutionCountriesReadQuery.getPagingSpec() == null ? IbanityPagingSpec.DEFAULT_PAGING_SPEC : financialInstitutionCountriesReadQuery.getPagingSpec();
        URI uri = URIHelper.buildUri(this.getUrl(), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, financialInstitutionCountriesReadQuery.getAdditionalHeaders(), null);
        return this.mapCollection(response);
    }

    private String getUrl() {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.Xs2a, "financialInstitutionCountries"), (String)"/");
    }

    private Collection<FinancialInstitutionCountry> mapCollection(HttpResponse httpResponse) {
        try {
            String jsonPayload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            CollectionApiModel collectionApiModel = (CollectionApiModel)IbanityUtils.objectMapper().readValue(jsonPayload, CollectionApiModel.class);
            String requestId = ModelMapperHelper.getRequestId(httpResponse);
            Collection<FinancialInstitutionCountry> collection = Collection.builder().requestId(requestId).pageLimit(collectionApiModel.getMeta().getPaging().getLimit()).afterCursor(collectionApiModel.getMeta().getPaging().getAfter()).beforeCursor(collectionApiModel.getMeta().getPaging().getBefore()).firstLink(collectionApiModel.getLinks().getFirst()).previousLink(collectionApiModel.getLinks().getPrev()).nextLink(collectionApiModel.getLinks().getNext()).items(collectionApiModel.getData().stream().map(this::mapFinancialInstitutionCountry).peek(value -> value.setRequestId(requestId)).collect(Collectors.toList())).build();
            return collection;
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
    }

    private FinancialInstitutionCountry mapFinancialInstitutionCountry(DataApiModel dataApiModel) {
        return FinancialInstitutionCountry.builder().id(dataApiModel.getId()).build();
    }
}

