/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.FinancialInstitution;
import com.ibanity.apis.client.products.xs2a.models.read.FinancialInstitutionReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.FinancialInstitutionsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.FinancialInstitutionsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionsServiceImpl
implements FinancialInstitutionsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IbanityCollection<FinancialInstitution> list(FinancialInstitutionsReadQuery financialInstitutionsReadQuery) {
        String customerAccessToken = financialInstitutionsReadQuery.getCustomerAccessToken();
        URI uri = this.isCursorBased(financialInstitutionsReadQuery) ? this.buildUriCursorBased(financialInstitutionsReadQuery, customerAccessToken) : this.buildUriOffsetBased(financialInstitutionsReadQuery, customerAccessToken);
        HttpResponse response = this.ibanityHttpClient.get(uri, financialInstitutionsReadQuery.getAdditionalHeaders(), customerAccessToken);
        return IbanityModelMapper.mapCollection(response, FinancialInstitution.class);
    }

    private boolean isCursorBased(FinancialInstitutionsReadQuery financialInstitutionsReadQuery) {
        return financialInstitutionsReadQuery.getOffsetPagingSpec() == null;
    }

    private URI buildUriOffsetBased(FinancialInstitutionsReadQuery financialInstitutionsReadQuery, String customerAccessToken) {
        return URIHelper.buildUri(StringUtils.removeEnd((String)this.getUrl(customerAccessToken).replace("{financialInstitutionId}", ""), (String)"/"), financialInstitutionsReadQuery.getOffsetPagingSpec(), financialInstitutionsReadQuery.getFilters());
    }

    private URI buildUriCursorBased(FinancialInstitutionsReadQuery financialInstitutionsReadQuery, String customerAccessToken) {
        return URIHelper.buildUri(StringUtils.removeEnd((String)this.getUrl(customerAccessToken).replace("{financialInstitutionId}", ""), (String)"/"), financialInstitutionsReadQuery.getPagingSpec(), financialInstitutionsReadQuery.getFilters());
    }

    @Override
    public FinancialInstitution find(FinancialInstitutionReadQuery financialInstitutionReadQuery) {
        String customerAccessToken = financialInstitutionReadQuery.getCustomerAccessToken();
        URI uri = URIHelper.buildUri(StringUtils.removeEnd((String)this.getUrl(customerAccessToken).replace("{financialInstitutionId}", financialInstitutionReadQuery.getFinancialInstitutionId().toString()), (String)"/"));
        HttpResponse response = this.ibanityHttpClient.get(uri, financialInstitutionReadQuery.getAdditionalHeaders(), customerAccessToken);
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    private String getUrl(String customerAccessToken) {
        if (StringUtils.isBlank((CharSequence)customerAccessToken)) {
            return this.apiUrlProvider.find(IbanityProduct.Xs2a, "financialInstitutions");
        }
        return this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitutions");
    }
}

