/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.models.Holding;
import com.ibanity.apis.client.products.xs2a.models.read.HoldingReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.HoldingsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.HoldingsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class HoldingsServiceImpl
implements HoldingsService {
    private final IbanityHttpClient ibanityHttpClient;
    private final ApiUrlProvider apiUrlProvider;

    public HoldingsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IbanityCollection<Holding> list(HoldingsReadQuery holdingsReadQuery) {
        IbanityPagingSpec pagingSpec = holdingsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrl(holdingsReadQuery.getFinancialInstitutionId(), holdingsReadQuery.getAccountId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), holdingsReadQuery.getAdditionalHeaders(), holdingsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, Holding.class);
    }

    @Override
    public Holding find(HoldingReadQuery holdingReadQuery) {
        String url = this.getUrl(holdingReadQuery.getFinancialInstitutionId(), holdingReadQuery.getAccountId()) + "/" + holdingReadQuery.getHoldingId().toString();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), holdingReadQuery.getAdditionalHeaders(), holdingReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, Holding.class);
    }

    private String getUrl(UUID financialInstitutionId, UUID accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "account", "holdings");
        return StringUtils.removeEnd((String)url.replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountId}", accountId.toString()).replace("{holdingId}", ""), (String)"/");
    }
}

