/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.create.PaymentInitiationRequestAuthorizationCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.links.PaymentInitiationRequestAuthorizationLinks;
import com.ibanity.apis.client.products.xs2a.services.PaymentInitiationRequestAuthorizationsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PaymentInitiationRequestAuthorizationsServiceImpl
implements PaymentInitiationRequestAuthorizationsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public PaymentInitiationRequestAuthorizationsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.xs2a.models.PaymentInitiationRequestAuthorization create(PaymentInitiationRequestAuthorizationCreationQuery authorizationCreationQuery) {
        UUID financialInstitutionId = authorizationCreationQuery.getFinancialInstitutionId();
        UUID paymentInitiationRequestId = authorizationCreationQuery.getPaymentInitiationRequestId();
        URI uri = this.getUrl(financialInstitutionId, paymentInitiationRequestId);
        PaymentInitiationRequestAuthorization ibanityModel = this.mapAttributes(authorizationCreationQuery);
        RequestApiModel request = ModelMapperHelper.buildRequest("authorization", ibanityModel);
        HttpResponse response = this.ibanityHttpClient.post(uri, request, authorizationCreationQuery.getAdditionalHeaders(), authorizationCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, this.responseMapping());
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.xs2a.models.PaymentInitiationRequestAuthorization> responseMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.xs2a.models.PaymentInitiationRequestAuthorization paymentInitiationRequestAuthorization = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.xs2a.models.PaymentInitiationRequestAuthorization.class);
            if (dataApiModel.getLinks() != null && dataApiModel.getLinks().getNextRedirect() != null) {
                paymentInitiationRequestAuthorization.setLinks(PaymentInitiationRequestAuthorizationLinks.builder().nextRedirect(dataApiModel.getLinks().getNextRedirect()).build());
            }
            return paymentInitiationRequestAuthorization;
        };
    }

    private URI getUrl(UUID financialInstitutionId, UUID paymentInitiationRequestId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "paymentInitiationRequest", "authorizations").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{paymentInitiationRequestId}", paymentInitiationRequestId.toString()).replace("{authorizationId}", "");
        return URIHelper.buildUri(StringUtils.removeEnd((String)url, (String)"/"));
    }

    private PaymentInitiationRequestAuthorization mapAttributes(PaymentInitiationRequestAuthorizationCreationQuery authorizationCreationQuery) {
        return PaymentInitiationRequestAuthorization.builder().queryParameters(authorizationCreationQuery.getQueryParameters()).build();
    }

    static class PaymentInitiationRequestAuthorization
    implements IbanityModel {
        public static final String RESOURCE_TYPE = "authorization";
        public static final String API_URL_TAG_ID = "{authorizationId}";
        private UUID id;
        private String selfLink;
        private String requestId;
        private Map<String, String> queryParameters;

        @Generated
        private static Map<String, String> $default$queryParameters() {
            return Collections.emptyMap();
        }

        @Generated
        public static PaymentInitiationRequestAuthorizationBuilder builder() {
            return new PaymentInitiationRequestAuthorizationBuilder();
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getSelfLink() {
            return this.selfLink;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public Map<String, String> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        @Generated
        public void setId(UUID id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setSelfLink(String selfLink) {
            this.selfLink = selfLink;
        }

        @Override
        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = queryParameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentInitiationRequestAuthorization)) {
                return false;
            }
            PaymentInitiationRequestAuthorization other = (PaymentInitiationRequestAuthorization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$selfLink = this.getSelfLink();
            String other$selfLink = other.getSelfLink();
            if (this$selfLink == null ? other$selfLink != null : !this$selfLink.equals(other$selfLink)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            Map<String, String> this$queryParameters = this.getQueryParameters();
            Map<String, String> other$queryParameters = other.getQueryParameters();
            return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentInitiationRequestAuthorization;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $selfLink = this.getSelfLink();
            result = result * 59 + ($selfLink == null ? 43 : $selfLink.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            Map<String, String> $queryParameters = this.getQueryParameters();
            result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PaymentInitiationRequestAuthorizationsServiceImpl.PaymentInitiationRequestAuthorization(id=" + this.getId() + ", selfLink=" + this.getSelfLink() + ", requestId=" + this.getRequestId() + ", queryParameters=" + this.getQueryParameters() + ")";
        }

        @Generated
        public PaymentInitiationRequestAuthorization() {
            this.queryParameters = PaymentInitiationRequestAuthorization.$default$queryParameters();
        }

        @Generated
        private PaymentInitiationRequestAuthorization(UUID id, String selfLink, String requestId, Map<String, String> queryParameters) {
            this.id = id;
            this.selfLink = selfLink;
            this.requestId = requestId;
            this.queryParameters = queryParameters;
        }

        @Generated
        public static class PaymentInitiationRequestAuthorizationBuilder {
            @Generated
            private UUID id;
            @Generated
            private String selfLink;
            @Generated
            private String requestId;
            @Generated
            private boolean queryParameters$set;
            @Generated
            private Map<String, String> queryParameters$value;

            @Generated
            PaymentInitiationRequestAuthorizationBuilder() {
            }

            @Generated
            public PaymentInitiationRequestAuthorizationBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            @Generated
            public PaymentInitiationRequestAuthorizationBuilder selfLink(String selfLink) {
                this.selfLink = selfLink;
                return this;
            }

            @Generated
            public PaymentInitiationRequestAuthorizationBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public PaymentInitiationRequestAuthorizationBuilder queryParameters(Map<String, String> queryParameters) {
                this.queryParameters$value = queryParameters;
                this.queryParameters$set = true;
                return this;
            }

            @Generated
            public PaymentInitiationRequestAuthorization build() {
                Map queryParameters$value = this.queryParameters$value;
                if (!this.queryParameters$set) {
                    queryParameters$value = PaymentInitiationRequestAuthorization.$default$queryParameters();
                }
                return new PaymentInitiationRequestAuthorization(this.id, this.selfLink, this.requestId, queryParameters$value);
            }

            @Generated
            public String toString() {
                return "PaymentInitiationRequestAuthorizationsServiceImpl.PaymentInitiationRequestAuthorization.PaymentInitiationRequestAuthorizationBuilder(id=" + this.id + ", selfLink=" + this.selfLink + ", requestId=" + this.requestId + ", queryParameters$value=" + this.queryParameters$value + ")";
            }
        }
    }
}

