/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.models.PendingTransaction;
import com.ibanity.apis.client.products.xs2a.models.read.PendingTransactionReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.PendingTransactionsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.PendingTransactionsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PendingTransactionsServiceImpl
implements PendingTransactionsService {
    private final IbanityHttpClient ibanityHttpClient;
    private final ApiUrlProvider apiUrlProvider;

    public PendingTransactionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IbanityCollection<PendingTransaction> list(PendingTransactionsReadQuery pendingTransactionsReadQuery) {
        IbanityPagingSpec pagingSpec = pendingTransactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrl(pendingTransactionsReadQuery.getFinancialInstitutionId(), pendingTransactionsReadQuery.getAccountId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), pendingTransactionsReadQuery.getAdditionalHeaders(), pendingTransactionsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, PendingTransaction.class);
    }

    @Override
    public IbanityCollection<PendingTransaction> listUpdatedForSynchronization(PendingTransactionsReadQuery pendingTransactionsReadQuery) {
        IbanityPagingSpec pagingSpec = pendingTransactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrlForSynchronizationId(pendingTransactionsReadQuery.getSynchronizationId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), pendingTransactionsReadQuery.getAdditionalHeaders(), pendingTransactionsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, PendingTransaction.class);
    }

    @Override
    public PendingTransaction find(PendingTransactionReadQuery pendingTransactionReadQuery) {
        String url = this.getUrl(pendingTransactionReadQuery.getFinancialInstitutionId(), pendingTransactionReadQuery.getAccountId()) + "/" + pendingTransactionReadQuery.getPendingTransactionId().toString();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), pendingTransactionReadQuery.getAdditionalHeaders(), pendingTransactionReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, PendingTransaction.class);
    }

    private String getUrl(UUID financialInstitutionId, UUID accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "account", "pendingTransactions").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountId}", accountId.toString()).replace("{pendingTransactionId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private String getUrlForSynchronizationId(UUID synchronizationId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "synchronization", "updatedPendingTransactions").replace("{synchronizationId}", synchronizationId.toString());
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

