/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.mappers.SynchronizationMapper;
import com.ibanity.apis.client.products.xs2a.models.Synchronization;
import com.ibanity.apis.client.products.xs2a.models.create.SynchronizationCreationQuery;
import com.ibanity.apis.client.products.xs2a.models.read.SynchronizationReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.SynchronizationsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.SynchronizationService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class SynchronizationServiceImpl
implements SynchronizationService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public SynchronizationServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Synchronization create(SynchronizationCreationQuery synchronizationCreationQuery) {
        Synchronization synchronization = Synchronization.builder().resourceId(synchronizationCreationQuery.getResourceId()).resourceType(synchronizationCreationQuery.getResourceType()).subtype(synchronizationCreationQuery.getSubtype()).customerOnline(synchronizationCreationQuery.getCustomerOnline()).customerIpAddress(synchronizationCreationQuery.getCustomerIpAddress()).build();
        String url = this.getUrl();
        RequestApiModel request = ModelMapperHelper.buildRequest("synchronization", synchronization);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, synchronizationCreationQuery.getAdditionalHeaders(), synchronizationCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, SynchronizationMapper::map);
    }

    @Override
    public Synchronization find(SynchronizationReadQuery synchronizationReadQuery) {
        String url = this.getUrl() + "/" + synchronizationReadQuery.getSynchronizationId().toString();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), synchronizationReadQuery.getAdditionalHeaders(), synchronizationReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, SynchronizationMapper::map);
    }

    @Override
    public IbanityCollection<Synchronization> list(SynchronizationsReadQuery synchronizationsReadQuery) {
        IbanityPagingSpec pagingSpec = synchronizationsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrl(synchronizationsReadQuery.getFinancialInstitutionId(), synchronizationsReadQuery.getAccountInformationAccessRequestId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), synchronizationsReadQuery.getAdditionalHeaders(), synchronizationsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, Synchronization.class);
    }

    private String getUrl() {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "synchronizations");
        return StringUtils.removeEnd((String)url.replace("{synchronizationId}", ""), (String)"/");
    }

    private String getUrl(UUID financialInstitutionId, UUID accountInformationAccessRequestsId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "accountInformationAccessRequest", "initialAccountTransactionsSynchronizations").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountInformationAccessRequestId}", accountInformationAccessRequestsId.toString());
        return StringUtils.removeEnd((String)url.replace("{synchronizationId}", ""), (String)"/");
    }
}

