/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.xs2a.models.TransactionDeleteRequest;
import com.ibanity.apis.client.products.xs2a.models.create.TransactionDeleteRequestCreationQuery;
import com.ibanity.apis.client.products.xs2a.services.TransactionDeleteRequestsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.http.HttpResponse;

public class TransactionDeleteRequestsServiceImpl
implements TransactionDeleteRequestsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public TransactionDeleteRequestsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public TransactionDeleteRequest createForApplication(TransactionDeleteRequestCreationQuery transactionDeleteRequestCreationQuery) {
        TransactionDeleteRequest transactionDeleteRequest = TransactionDeleteRequest.builder().beforeDate(transactionDeleteRequestCreationQuery.getBeforeDate()).build();
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "transactionDeleteRequests");
        RequestApiModel request = ModelMapperHelper.buildRequest("transactionDeleteRequest", transactionDeleteRequest);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, transactionDeleteRequestCreationQuery.getAdditionalHeaders(), null);
        return IbanityModelMapper.mapResource(response, TransactionDeleteRequest.class);
    }

    @Override
    public TransactionDeleteRequest createForCustomer(TransactionDeleteRequestCreationQuery transactionDeleteRequestCreationQuery) {
        TransactionDeleteRequest transactionDeleteRequest = TransactionDeleteRequest.builder().beforeDate(transactionDeleteRequestCreationQuery.getBeforeDate()).build();
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "transactionDeleteRequests");
        RequestApiModel request = ModelMapperHelper.buildRequest("transactionDeleteRequest", transactionDeleteRequest);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, transactionDeleteRequestCreationQuery.getAdditionalHeaders(), transactionDeleteRequestCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, TransactionDeleteRequest.class);
    }

    @Override
    public TransactionDeleteRequest createForAccount(TransactionDeleteRequestCreationQuery transactionDeleteRequestCreationQuery) {
        TransactionDeleteRequest transactionDeleteRequest = TransactionDeleteRequest.builder().beforeDate(transactionDeleteRequestCreationQuery.getBeforeDate()).build();
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "account", "transactionDeleteRequests").replace("{financialInstitutionId}", transactionDeleteRequestCreationQuery.getFinancialInstitutionId().toString()).replace("{accountId}", transactionDeleteRequestCreationQuery.getAccountId().toString());
        RequestApiModel request = ModelMapperHelper.buildRequest("transactionDeleteRequest", transactionDeleteRequest);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, transactionDeleteRequestCreationQuery.getAdditionalHeaders(), transactionDeleteRequestCreationQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, TransactionDeleteRequest.class);
    }
}

