/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.xs2a.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.xs2a.models.Transaction;
import com.ibanity.apis.client.products.xs2a.models.read.TransactionReadQuery;
import com.ibanity.apis.client.products.xs2a.models.read.TransactionsReadQuery;
import com.ibanity.apis.client.products.xs2a.services.TransactionsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class TransactionsServiceImpl
implements TransactionsService {
    private final IbanityHttpClient ibanityHttpClient;
    private final ApiUrlProvider apiUrlProvider;

    public TransactionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IbanityCollection<Transaction> list(TransactionsReadQuery transactionsReadQuery) {
        IbanityPagingSpec pagingSpec = transactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrl(transactionsReadQuery.getFinancialInstitutionId(), transactionsReadQuery.getAccountId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), transactionsReadQuery.getAdditionalHeaders(), transactionsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, Transaction.class);
    }

    @Override
    public IbanityCollection<Transaction> listUpdatedForSynchronization(TransactionsReadQuery transactionsReadQuery) {
        IbanityPagingSpec pagingSpec = transactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        String url = this.getUrlForSynchronizationId(transactionsReadQuery.getSynchronizationId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, pagingSpec), transactionsReadQuery.getAdditionalHeaders(), transactionsReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapCollection(response, Transaction.class);
    }

    @Override
    public Transaction find(TransactionReadQuery transactionReadQuery) {
        String url = this.getUrl(transactionReadQuery.getFinancialInstitutionId(), transactionReadQuery.getAccountId()) + "/" + transactionReadQuery.getTransactionId().toString();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), transactionReadQuery.getAdditionalHeaders(), transactionReadQuery.getCustomerAccessToken());
        return IbanityModelMapper.mapResource(response, Transaction.class);
    }

    private String getUrl(UUID financialInstitutionId, UUID accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "financialInstitution", "account", "transactions").replace("{financialInstitutionId}", financialInstitutionId.toString()).replace("{accountId}", accountId.toString()).replace("{transactionId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private String getUrlForSynchronizationId(UUID synchronizationId) {
        String url = this.apiUrlProvider.find(IbanityProduct.Xs2a, "customer", "synchronization", "updatedTransactions").replace("{synchronizationId}", synchronizationId.toString());
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

