/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpRequestRetryHandler.class);
    private static final int DEFAULT_RETRY_COUNT = 3;
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private final Set<Class<? extends IOException>> nonRetriableClasses;

    protected CustomHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled, Collection<Class<? extends IOException>> clazzes) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
        this.nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        this.nonRetriableClasses.addAll(clazzes);
    }

    public CustomHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this(retryCount, requestSentRetryEnabled, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
    }

    public CustomHttpRequestRetryHandler() {
        this(3, false);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        LOGGER.debug("Retry request");
        if (executionCount > this.retryCount) {
            LOGGER.debug("Do not retry HttpRequest anymore because over max retryCount");
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return this.verifyNonRetriableException(exception);
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            LOGGER.debug("Do not retry HttpRequest anymore because instance of non-retriable exception class " + exception.getClass());
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            LOGGER.debug("Do not retry HttpRequest anymore because request is aborted");
            return false;
        }
        if (this.handleAsIdempotent(request)) {
            LOGGER.debug("Retry because request is idempotent!");
            return true;
        }
        if (!clientContext.isRequestSent() || this.requestSentRetryEnabled) {
            LOGGER.debug("Retry because request not fully sent");
            return true;
        }
        LOGGER.debug("Do not retry HttpRequest anymore because ... no other conditions");
        return false;
    }

    private boolean verifyNonRetriableException(IOException exception) {
        if (exception.getClass().equals(SSLException.class)) {
            SSLException sslException = (SSLException)exception;
            if ("Received fatal alert: unexpected_message".equals(sslException.getMessage())) {
                LOGGER.debug("Retry on unexpected_message");
                return true;
            }
            LOGGER.debug("Don't retry because SSLException with message " + sslException.getMessage());
            return false;
        }
        LOGGER.debug("Do not retry HttpRequest anymore because non retriable exception class " + exception.getClass());
        return false;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }

    @Deprecated
    protected boolean requestIsAborted(HttpRequest request) {
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            req = ((RequestWrapper)request).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
    }
}

