/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.ibanity.apis.client.builders.IbanityConfiguration;
import com.ibanity.apis.client.http.interceptor.IbanitySignatureInterceptor;
import com.ibanity.apis.client.http.interceptor.IdempotencyInterceptor;
import com.ibanity.apis.client.http.service.impl.IbanityHttpSignatureServiceImpl;
import com.ibanity.apis.client.models.SignatureCredentials;
import com.ibanity.apis.client.models.TlsCredentials;
import com.ibanity.apis.client.utils.CustomHttpRequestRetryHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;

public final class IbanityUtils {
    public static final int DEFAULT_REQUEST_TIMEOUT = 30000;
    public static final int DEFAULT_JWKS_CACHE_TTL = 60000;
    public static final int DEFAULT_JWT_CLOCK_SKEW = 30;
    private static final int RETRY_COUNTS = 10;
    private static final String ALIAS_KEY_STORE = "application certificate";
    private static final String CA_TRUST_STORE_KEY = "ibanity-ca";
    private static final String TLS_PROTOCOL = "TLS";

    private IbanityUtils() {
    }

    @Deprecated
    public static HttpClient httpClient(Certificate caCertificate, TlsCredentials tlsCredentials, SignatureCredentials signatureCertificate, String basePath) {
        try {
            SSLContext sslContext = IbanityUtils.getSSLContext(caCertificate, tlsCredentials);
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            IbanityConfiguration ibanityConfiguration = IbanityConfiguration.builder().signatureCredentials(signatureCertificate).apiEndpoint(basePath).build();
            IbanityUtils.configureHttpClient(sslContext, httpClientBuilder, ibanityConfiguration);
            return httpClientBuilder.build();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("An exception occurred while creating IbanityHttpClient", exception);
        }
    }

    public static HttpClient httpClient(IbanityConfiguration configuration) {
        try {
            SSLContext sslContext = IbanityUtils.getSSLContext(configuration.getCaCertificate(), configuration.getTlsCredentials());
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            IbanityUtils.configureHttpClient(sslContext, httpClientBuilder, configuration);
            configuration.getHttpRequestInterceptors().forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addInterceptorLast(arg_0));
            configuration.getHttpResponseInterceptors().forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addInterceptorFirst(arg_0));
            return httpClientBuilder.build();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("An exception occurred while creating IbanityHttpClient", exception);
        }
    }

    public static ObjectMapper objectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private static void configureHttpClient(SSLContext sslContext, HttpClientBuilder httpClientBuilder, IbanityConfiguration configuration) {
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new CustomHttpRequestRetryHandler(10, true));
        httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new IdempotencyInterceptor());
        SignatureCredentials signatureCredentials = configuration.getSignatureCredentials();
        String apiEndpoint = configuration.getApiEndpoint();
        if (signatureCredentials != null) {
            IbanityHttpSignatureServiceImpl httpSignatureService = IbanityUtils.getIbanityHttpSignatureService(signatureCredentials, apiEndpoint, configuration.getProxyEndpoint());
            httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new IbanitySignatureInterceptor(httpSignatureService, apiEndpoint));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(configuration.getConnectTimeout()).setSocketTimeout(configuration.getSocketTimeout()).setConnectionRequestTimeout(configuration.getConnectionRequestTimeout()).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultClientConnectionReuseStrategy());
    }

    public static SSLContext getSSLContext(IbanityConfiguration ibanityConfiguration) {
        return IbanityUtils.getSSLContext(ibanityConfiguration.getCaCertificate(), ibanityConfiguration.getTlsCredentials());
    }

    public static SSLContext getSSLContext(Certificate caCertificate, TlsCredentials tlsCredentials) {
        try {
            KeyManager[] keyManagers = null;
            if (tlsCredentials != null) {
                KeyStore keyStore = IbanityUtils.createKeyStore(tlsCredentials);
                keyManagers = IbanityUtils.createKeyManagers(keyStore, tlsCredentials.getPrivateKeyPassphrase());
            }
            TrustManager[] trustManagers = null;
            if (caCertificate != null) {
                KeyStore trustStore = IbanityUtils.createTrustStore(caCertificate);
                trustManagers = IbanityUtils.createTrustManagers(trustStore);
            }
            SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("An exception occurred while creating IbanityHttpClient", exception);
        }
    }

    private static TrustManager[] createTrustManagers(KeyStore trustStore) throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyStore createTrustStore(Certificate certificate) throws GeneralSecurityException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        if (!trustStore.containsAlias(CA_TRUST_STORE_KEY)) {
            trustStore.setCertificateEntry(CA_TRUST_STORE_KEY, certificate);
        }
        return trustStore;
    }

    private static KeyStore createKeyStore(TlsCredentials tlsCredentials) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        if (!keyStore.containsAlias(ALIAS_KEY_STORE)) {
            keyStore.setKeyEntry(ALIAS_KEY_STORE, tlsCredentials.getPrivateKey(), tlsCredentials.getPrivateKeyPassphrase().toCharArray(), new Certificate[]{tlsCredentials.getCertificate()});
        }
        return keyStore;
    }

    private static IbanityHttpSignatureServiceImpl getIbanityHttpSignatureService(SignatureCredentials signatureCertificate, String ibanityApiEndpoint, String proxyEndpoint) {
        return new IbanityHttpSignatureServiceImpl(signatureCertificate.getPrivateKey(), signatureCertificate.getCertificateId(), ibanityApiEndpoint, proxyEndpoint);
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String passphrase) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, passphrase.toCharArray());
        return kmf.getKeyManagers();
    }
}

