/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.utils;

import com.ibanity.apis.client.paging.IbanityOffsetPagingSpec;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.isabel_connect.models.read.IsabelPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.helpers.FilterHelper;
import com.ibanity.apis.client.products.ponto_connect.models.Filter;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class URIHelper {
    public static URI buildUri(@NonNull String url, IsabelPagingSpec pagingSpec) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return URIHelper.buildUri(url, pagingSpec, Collections.emptyMap());
    }

    public static URI buildUri(@NonNull String url, IsabelPagingSpec pagingSpec, Map<String, String> queryParameters) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            pagingSpec = pagingSpec == null ? IsabelPagingSpec.DEFAULT_PAGING_SPEC : pagingSpec;
            URIBuilder uriBuilder = new URIBuilder(StringUtils.removeEnd((String)url, (String)"/"));
            URIHelper.addIfNotNull(uriBuilder, "offset", pagingSpec.getOffset());
            URIHelper.addIfNotNull(uriBuilder, "size", pagingSpec.getSize());
            URIHelper.addIfNotNull(uriBuilder, "from", pagingSpec.getFrom());
            URIHelper.addIfNotNull(uriBuilder, "to", pagingSpec.getTo());
            URIHelper.addQueryParameters(uriBuilder, queryParameters);
            return uriBuilder.build();
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("URL cannot be build", exception);
        }
    }

    public static URI buildUri(@NonNull String url, IbanityPagingSpec pagingSpec) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return URIHelper.buildUri(url, pagingSpec, Collections.emptyList());
    }

    public static URI buildUri(@NonNull String url, IbanityPagingSpec pagingSpec, List<Filter> filters) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            pagingSpec = pagingSpec == null ? IbanityPagingSpec.DEFAULT_PAGING_SPEC : pagingSpec;
            URIBuilder uriBuilder = new URIBuilder(StringUtils.removeEnd((String)url, (String)"/"));
            URIHelper.addIfNotNull(uriBuilder, "page[before]", pagingSpec.getBefore());
            URIHelper.addIfNotNull(uriBuilder, "page[after]", pagingSpec.getAfter());
            URIHelper.addIfNotNull(uriBuilder, "page[limit]", pagingSpec.getLimit());
            URIHelper.addFilters(uriBuilder, filters);
            return uriBuilder.build();
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("URL cannot be build", exception);
        }
    }

    public static URI buildUri(@NonNull String url, IbanityOffsetPagingSpec pagingSpec, List<Filter> filters) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            pagingSpec = pagingSpec == null ? IbanityOffsetPagingSpec.DEFAULT_OFFSET_PAGING_SPEC : pagingSpec;
            URIBuilder uriBuilder = new URIBuilder(StringUtils.removeEnd((String)url, (String)"/"));
            URIHelper.addIfNotNull(uriBuilder, "page[size]", pagingSpec.getPageSize());
            URIHelper.addIfNotNull(uriBuilder, "page[number]", pagingSpec.getPageNumber());
            URIHelper.addFilters(uriBuilder, filters);
            return uriBuilder.build();
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("URL cannot be build", exception);
        }
    }

    private static void addFilters(URIBuilder uriBuilder, List<Filter> filters) {
        filters.forEach(filter -> uriBuilder.addParameters(FilterHelper.encode(filter)));
    }

    public static URI buildUri(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return new URIBuilder(url).build();
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("URL cannot be build", exception);
        }
    }

    private static void addIfNotNull(URIBuilder uriBuilder, String paramName, Object paramValue) {
        if (paramValue != null) {
            uriBuilder.addParameter(paramName, paramValue.toString());
        }
    }

    private static void addIfNotNull(URIBuilder uriBuilder, String paramName, LocalDate paramValue) {
        if (paramValue != null) {
            uriBuilder.addParameter(paramName, paramValue.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    private static void addQueryParameters(URIBuilder uriBuilder, Map<String, String> parameters) {
        parameters.forEach((key, value) -> URIHelper.addIfNotNull(uriBuilder, key, value));
    }
}

