/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.utils;

import com.ibanity.apis.client.exceptions.IbanityRuntimeException;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import com.ibanity.apis.client.webhooks.models.ponto_connect.AccountReauthorized;
import com.ibanity.apis.client.webhooks.models.ponto_connect.AccountTransactionsCreated;
import com.ibanity.apis.client.webhooks.models.ponto_connect.IntegrationAccountAdded;
import com.ibanity.apis.client.webhooks.models.ponto_connect.IntegrationAccountRevoked;
import com.ibanity.apis.client.webhooks.models.ponto_connect.IntegrationCreated;
import com.ibanity.apis.client.webhooks.models.ponto_connect.IntegrationRevoked;
import com.ibanity.apis.client.webhooks.models.ponto_connect.OrganizationBlocked;
import com.ibanity.apis.client.webhooks.models.ponto_connect.OrganizationUnblocked;
import com.ibanity.apis.client.webhooks.models.ponto_connect.PaymentRequestClosed;
import com.ibanity.apis.client.webhooks.models.ponto_connect.SynchronizationFailed;
import com.ibanity.apis.client.webhooks.models.xs2a.AccountDetailsUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.AccountPendingTransactionsCreated;
import com.ibanity.apis.client.webhooks.models.xs2a.AccountPendingTransactionsUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.AccountTransactionsDeleted;
import com.ibanity.apis.client.webhooks.models.xs2a.AccountTransactionsUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.BulkPaymentInitiationRequestAuthorizationCompleted;
import com.ibanity.apis.client.webhooks.models.xs2a.BulkPaymentInitiationRequestStatusUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.PaymentInitiationRequestAuthorizationCompleted;
import com.ibanity.apis.client.webhooks.models.xs2a.PaymentInitiationRequestStatusUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.PeriodicPaymentInitiationRequestAuthorizationCompleted;
import com.ibanity.apis.client.webhooks.models.xs2a.PeriodicPaymentInitiationRequestStatusUpdated;
import com.ibanity.apis.client.webhooks.models.xs2a.SynchronizationSucceededWithoutChange;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class WebhooksUtils {
    private static final String DIGEST_ALGORITHM = "SHA-512";
    private static final int BUFFER_SIZE = 32768;

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unsupported digest algorithm:SHA-512");
        }
    }

    public static String getDigest(String payload) {
        MessageDigest md = WebhooksUtils.getMessageDigest();
        try (BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(payload.getBytes()));){
            int length;
            byte[] buffer = new byte[32768];
            while ((length = stream.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read payload.");
        }
        return Base64.getEncoder().encodeToString(md.digest());
    }

    public static IbanityWebhookEvent webhookEventParser(String payload, String type) {
        if (type.contains("xs2a.")) {
            return WebhooksUtils.parseXs2aEvent(payload, type);
        }
        return WebhooksUtils.parsePontoConnectEvent(payload, type);
    }

    private static IbanityWebhookEvent parseXs2aEvent(String payload, String type) {
        switch (type) {
            case "xs2a.account.detailsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountDetailsUpdated.mappingFunction());
            }
            case "xs2a.account.transactionsCreated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.xs2a.AccountTransactionsCreated.mappingFunction());
            }
            case "xs2a.account.transactionsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountTransactionsUpdated.mappingFunction());
            }
            case "xs2a.account.transactionsDeleted": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountTransactionsDeleted.mappingFunction());
            }
            case "xs2a.account.pendingTransactionsCreated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountPendingTransactionsCreated.mappingFunction());
            }
            case "xs2a.account.pendingTransactionsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountPendingTransactionsUpdated.mappingFunction());
            }
            case "xs2a.synchronization.failed": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.xs2a.SynchronizationFailed.mappingFunction());
            }
            case "xs2a.synchronization.succeededWithoutChange": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, SynchronizationSucceededWithoutChange.mappingFunction());
            }
            case "xs2a.bulkPaymentInitiationRequest.authorizationCompleted": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, BulkPaymentInitiationRequestAuthorizationCompleted.mappingFunction());
            }
            case "xs2a.bulkPaymentInitiationRequest.statusUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, BulkPaymentInitiationRequestStatusUpdated.mappingFunction());
            }
            case "xs2a.paymentInitiationRequest.authorizationCompleted": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, PaymentInitiationRequestAuthorizationCompleted.mappingFunction());
            }
            case "xs2a.paymentInitiationRequest.statusUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, PaymentInitiationRequestStatusUpdated.mappingFunction());
            }
            case "xs2a.periodicPaymentInitiationRequest.authorizationCompleted": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, PeriodicPaymentInitiationRequestAuthorizationCompleted.mappingFunction());
            }
            case "xs2a.periodicPaymentInitiationRequest.statusUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, PeriodicPaymentInitiationRequestStatusUpdated.mappingFunction());
            }
        }
        throw new IbanityRuntimeException(String.format("Event Type not handled by the java library \"%s\".", type));
    }

    private static IbanityWebhookEvent parsePontoConnectEvent(String payload, String type) {
        switch (type) {
            case "pontoConnect.account.detailsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.ponto_connect.AccountDetailsUpdated.mappingFunction());
            }
            case "pontoConnect.account.transactionsCreated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountTransactionsCreated.mappingFunction());
            }
            case "pontoConnect.account.transactionsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.ponto_connect.AccountTransactionsUpdated.mappingFunction());
            }
            case "pontoConnect.account.pendingTransactionsCreated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.ponto_connect.AccountPendingTransactionsCreated.mappingFunction());
            }
            case "pontoConnect.account.pendingTransactionsUpdated": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.ponto_connect.AccountPendingTransactionsUpdated.mappingFunction());
            }
            case "pontoConnect.synchronization.failed": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, SynchronizationFailed.mappingFunction());
            }
            case "pontoConnect.synchronization.succeededWithoutChange": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, com.ibanity.apis.client.webhooks.models.ponto_connect.SynchronizationSucceededWithoutChange.mappingFunction());
            }
            case "pontoConnect.integration.accountAdded": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, IntegrationAccountAdded.mappingFunction());
            }
            case "pontoConnect.integration.accountRevoked": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, IntegrationAccountRevoked.mappingFunction());
            }
            case "pontoConnect.integration.created": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, IntegrationCreated.mappingFunction());
            }
            case "pontoConnect.integration.revoked": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, IntegrationRevoked.mappingFunction());
            }
            case "pontoConnect.organization.blocked": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, OrganizationBlocked.mappingFunction());
            }
            case "pontoConnect.organization.unblocked": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, OrganizationUnblocked.mappingFunction());
            }
            case "pontoConnect.account.reauthorized": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, AccountReauthorized.mappingFunction());
            }
            case "pontoConnect.paymentRequest.closed": {
                return IbanityWebhookEventMapper.mapWebhookResource(payload, PaymentRequestClosed.mappingFunction());
            }
        }
        throw new IbanityRuntimeException(String.format("Event Type not handled by the java library \"%s\".", type));
    }
}

