/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.ponto_connect;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class AccountPendingTransactionsCreated
implements IbanityWebhookEvent {
    public static final String TYPE = "pontoConnect.account.pendingTransactionsCreated";
    private UUID id;
    private String type;
    private UUID accountId;
    private int count;
    private UUID synchronizationId;
    private UUID organizationId;
    private Instant createdAt;

    public static Function<DataApiModel, AccountPendingTransactionsCreated> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel organizationRelationship;
            RelationshipsApiModel synchronizationRelationship;
            AccountPendingTransactionsCreated accountPendingTransactionsCreated = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, AccountPendingTransactionsCreated.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                accountPendingTransactionsCreated.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((synchronizationRelationship = dataApiModel.getRelationships().get("synchronization")) != null) {
                accountPendingTransactionsCreated.setSynchronizationId(UUID.fromString(synchronizationRelationship.getData().getId()));
            }
            if ((organizationRelationship = dataApiModel.getRelationships().get("organization")) != null) {
                accountPendingTransactionsCreated.setOrganizationId(UUID.fromString(organizationRelationship.getData().getId()));
            }
            return accountPendingTransactionsCreated;
        };
    }

    @Generated
    protected AccountPendingTransactionsCreated(AccountPendingTransactionsCreatedBuilder<?, ?> b) {
        this.id = ((AccountPendingTransactionsCreatedBuilder)b).id;
        this.type = ((AccountPendingTransactionsCreatedBuilder)b).type;
        this.accountId = ((AccountPendingTransactionsCreatedBuilder)b).accountId;
        this.count = ((AccountPendingTransactionsCreatedBuilder)b).count;
        this.synchronizationId = ((AccountPendingTransactionsCreatedBuilder)b).synchronizationId;
        this.organizationId = ((AccountPendingTransactionsCreatedBuilder)b).organizationId;
        this.createdAt = ((AccountPendingTransactionsCreatedBuilder)b).createdAt;
    }

    @Generated
    public static AccountPendingTransactionsCreatedBuilder<?, ?> builder() {
        return new AccountPendingTransactionsCreatedBuilderImpl();
    }

    @Generated
    public AccountPendingTransactionsCreatedBuilder<?, ?> toBuilder() {
        return new AccountPendingTransactionsCreatedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public UUID getSynchronizationId() {
        return this.synchronizationId;
    }

    @Generated
    public UUID getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setSynchronizationId(UUID synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    @Generated
    public void setOrganizationId(UUID organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountPendingTransactionsCreated)) {
            return false;
        }
        AccountPendingTransactionsCreated other = (AccountPendingTransactionsCreated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$synchronizationId = this.getSynchronizationId();
        UUID other$synchronizationId = other.getSynchronizationId();
        if (this$synchronizationId == null ? other$synchronizationId != null : !((Object)this$synchronizationId).equals(other$synchronizationId)) {
            return false;
        }
        UUID this$organizationId = this.getOrganizationId();
        UUID other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountPendingTransactionsCreated;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $synchronizationId = this.getSynchronizationId();
        result = result * 59 + ($synchronizationId == null ? 43 : ((Object)$synchronizationId).hashCode());
        UUID $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountPendingTransactionsCreated(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", count=" + this.getCount() + ", synchronizationId=" + this.getSynchronizationId() + ", organizationId=" + this.getOrganizationId() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public AccountPendingTransactionsCreated() {
    }

    @Generated
    private AccountPendingTransactionsCreated(UUID id, String type, UUID accountId, int count, UUID synchronizationId, UUID organizationId, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.count = count;
        this.synchronizationId = synchronizationId;
        this.organizationId = organizationId;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class AccountPendingTransactionsCreatedBuilder<C extends AccountPendingTransactionsCreated, B extends AccountPendingTransactionsCreatedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private int count;
        @Generated
        private UUID synchronizationId;
        @Generated
        private UUID organizationId;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AccountPendingTransactionsCreatedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AccountPendingTransactionsCreated instance, AccountPendingTransactionsCreatedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.count(instance.count);
            b.synchronizationId(instance.synchronizationId);
            b.organizationId(instance.organizationId);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B count(int count) {
            this.count = count;
            return this.self();
        }

        @Generated
        public B synchronizationId(UUID synchronizationId) {
            this.synchronizationId = synchronizationId;
            return this.self();
        }

        @Generated
        public B organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AccountPendingTransactionsCreated.AccountPendingTransactionsCreatedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", count=" + this.count + ", synchronizationId=" + this.synchronizationId + ", organizationId=" + this.organizationId + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class AccountPendingTransactionsCreatedBuilderImpl
    extends AccountPendingTransactionsCreatedBuilder<AccountPendingTransactionsCreated, AccountPendingTransactionsCreatedBuilderImpl> {
        @Generated
        private AccountPendingTransactionsCreatedBuilderImpl() {
        }

        @Override
        @Generated
        protected AccountPendingTransactionsCreatedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AccountPendingTransactionsCreated build() {
            return new AccountPendingTransactionsCreated(this);
        }
    }
}

