/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.ponto_connect;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class AccountPendingTransactionsUpdated
implements IbanityWebhookEvent {
    public static final String TYPE = "pontoConnect.account.pendingTransactionsUpdated";
    private UUID id;
    private String type;
    private UUID accountId;
    private UUID synchronizationId;
    private UUID organizationId;
    private int count;
    private Instant createdAt;

    public static Function<DataApiModel, AccountPendingTransactionsUpdated> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel organizationRelationship;
            RelationshipsApiModel synchronizationRelationship;
            AccountPendingTransactionsUpdated accountPendingTransactionsUpdated = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, AccountPendingTransactionsUpdated.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                accountPendingTransactionsUpdated.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((synchronizationRelationship = dataApiModel.getRelationships().get("synchronization")) != null) {
                accountPendingTransactionsUpdated.setSynchronizationId(UUID.fromString(synchronizationRelationship.getData().getId()));
            }
            if ((organizationRelationship = dataApiModel.getRelationships().get("organization")) != null) {
                accountPendingTransactionsUpdated.setOrganizationId(UUID.fromString(organizationRelationship.getData().getId()));
            }
            return accountPendingTransactionsUpdated;
        };
    }

    @Generated
    protected AccountPendingTransactionsUpdated(AccountPendingTransactionsUpdatedBuilder<?, ?> b) {
        this.id = ((AccountPendingTransactionsUpdatedBuilder)b).id;
        this.type = ((AccountPendingTransactionsUpdatedBuilder)b).type;
        this.accountId = ((AccountPendingTransactionsUpdatedBuilder)b).accountId;
        this.synchronizationId = ((AccountPendingTransactionsUpdatedBuilder)b).synchronizationId;
        this.organizationId = ((AccountPendingTransactionsUpdatedBuilder)b).organizationId;
        this.count = ((AccountPendingTransactionsUpdatedBuilder)b).count;
        this.createdAt = ((AccountPendingTransactionsUpdatedBuilder)b).createdAt;
    }

    @Generated
    public static AccountPendingTransactionsUpdatedBuilder<?, ?> builder() {
        return new AccountPendingTransactionsUpdatedBuilderImpl();
    }

    @Generated
    public AccountPendingTransactionsUpdatedBuilder<?, ?> toBuilder() {
        return new AccountPendingTransactionsUpdatedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public UUID getSynchronizationId() {
        return this.synchronizationId;
    }

    @Generated
    public UUID getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setSynchronizationId(UUID synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    @Generated
    public void setOrganizationId(UUID organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountPendingTransactionsUpdated)) {
            return false;
        }
        AccountPendingTransactionsUpdated other = (AccountPendingTransactionsUpdated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$synchronizationId = this.getSynchronizationId();
        UUID other$synchronizationId = other.getSynchronizationId();
        if (this$synchronizationId == null ? other$synchronizationId != null : !((Object)this$synchronizationId).equals(other$synchronizationId)) {
            return false;
        }
        UUID this$organizationId = this.getOrganizationId();
        UUID other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountPendingTransactionsUpdated;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $synchronizationId = this.getSynchronizationId();
        result = result * 59 + ($synchronizationId == null ? 43 : ((Object)$synchronizationId).hashCode());
        UUID $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountPendingTransactionsUpdated(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", synchronizationId=" + this.getSynchronizationId() + ", organizationId=" + this.getOrganizationId() + ", count=" + this.getCount() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public AccountPendingTransactionsUpdated() {
    }

    @Generated
    private AccountPendingTransactionsUpdated(UUID id, String type, UUID accountId, UUID synchronizationId, UUID organizationId, int count, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.synchronizationId = synchronizationId;
        this.organizationId = organizationId;
        this.count = count;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class AccountPendingTransactionsUpdatedBuilder<C extends AccountPendingTransactionsUpdated, B extends AccountPendingTransactionsUpdatedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private UUID synchronizationId;
        @Generated
        private UUID organizationId;
        @Generated
        private int count;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AccountPendingTransactionsUpdatedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AccountPendingTransactionsUpdated instance, AccountPendingTransactionsUpdatedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.synchronizationId(instance.synchronizationId);
            b.organizationId(instance.organizationId);
            b.count(instance.count);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B synchronizationId(UUID synchronizationId) {
            this.synchronizationId = synchronizationId;
            return this.self();
        }

        @Generated
        public B organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            return this.self();
        }

        @Generated
        public B count(int count) {
            this.count = count;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AccountPendingTransactionsUpdated.AccountPendingTransactionsUpdatedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", synchronizationId=" + this.synchronizationId + ", organizationId=" + this.organizationId + ", count=" + this.count + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class AccountPendingTransactionsUpdatedBuilderImpl
    extends AccountPendingTransactionsUpdatedBuilder<AccountPendingTransactionsUpdated, AccountPendingTransactionsUpdatedBuilderImpl> {
        @Generated
        private AccountPendingTransactionsUpdatedBuilderImpl() {
        }

        @Override
        @Generated
        protected AccountPendingTransactionsUpdatedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AccountPendingTransactionsUpdated build() {
            return new AccountPendingTransactionsUpdated(this);
        }
    }
}

