/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.ponto_connect;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class IntegrationCreated
implements IbanityWebhookEvent {
    public static final String TYPE = "pontoConnect.integration.created";
    private UUID id;
    private String type;
    private UUID organization;
    private Instant createdAt;

    public static Function<DataApiModel, IntegrationCreated> mappingFunction() {
        return dataApiModel -> {
            IntegrationCreated integrationCreated = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, IntegrationCreated.class);
            RelationshipsApiModel organizationRelationship = dataApiModel.getRelationships().get("organization");
            if (organizationRelationship != null) {
                integrationCreated.setOrganization(UUID.fromString(organizationRelationship.getData().getId()));
            }
            return integrationCreated;
        };
    }

    @Generated
    protected IntegrationCreated(IntegrationCreatedBuilder<?, ?> b) {
        this.id = ((IntegrationCreatedBuilder)b).id;
        this.type = ((IntegrationCreatedBuilder)b).type;
        this.organization = ((IntegrationCreatedBuilder)b).organization;
        this.createdAt = ((IntegrationCreatedBuilder)b).createdAt;
    }

    @Generated
    public static IntegrationCreatedBuilder<?, ?> builder() {
        return new IntegrationCreatedBuilderImpl();
    }

    @Generated
    public IntegrationCreatedBuilder<?, ?> toBuilder() {
        return new IntegrationCreatedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getOrganization() {
        return this.organization;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOrganization(UUID organization) {
        this.organization = organization;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationCreated)) {
            return false;
        }
        IntegrationCreated other = (IntegrationCreated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$organization = this.getOrganization();
        UUID other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegrationCreated;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegrationCreated(id=" + this.getId() + ", type=" + this.getType() + ", organization=" + this.getOrganization() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public IntegrationCreated() {
    }

    @Generated
    private IntegrationCreated(UUID id, String type, UUID organization, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.organization = organization;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class IntegrationCreatedBuilder<C extends IntegrationCreated, B extends IntegrationCreatedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID organization;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            IntegrationCreatedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(IntegrationCreated instance, IntegrationCreatedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.organization(instance.organization);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B organization(UUID organization) {
            this.organization = organization;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "IntegrationCreated.IntegrationCreatedBuilder(id=" + this.id + ", type=" + this.type + ", organization=" + this.organization + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class IntegrationCreatedBuilderImpl
    extends IntegrationCreatedBuilder<IntegrationCreated, IntegrationCreatedBuilderImpl> {
        @Generated
        private IntegrationCreatedBuilderImpl() {
        }

        @Override
        @Generated
        protected IntegrationCreatedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IntegrationCreated build() {
            return new IntegrationCreated(this);
        }
    }
}

