/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.ponto_connect;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class IntegrationRevoked
implements IbanityWebhookEvent {
    public static final String TYPE = "pontoConnect.integration.revoked";
    private UUID id;
    private String type;
    private UUID organization;
    private Instant createdAt;

    public static Function<DataApiModel, IntegrationRevoked> mappingFunction() {
        return dataApiModel -> {
            IntegrationRevoked integrationRevoked = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, IntegrationRevoked.class);
            RelationshipsApiModel organizationRelationship = dataApiModel.getRelationships().get("organization");
            if (organizationRelationship != null) {
                integrationRevoked.setOrganization(UUID.fromString(organizationRelationship.getData().getId()));
            }
            return integrationRevoked;
        };
    }

    @Generated
    protected IntegrationRevoked(IntegrationRevokedBuilder<?, ?> b) {
        this.id = ((IntegrationRevokedBuilder)b).id;
        this.type = ((IntegrationRevokedBuilder)b).type;
        this.organization = ((IntegrationRevokedBuilder)b).organization;
        this.createdAt = ((IntegrationRevokedBuilder)b).createdAt;
    }

    @Generated
    public static IntegrationRevokedBuilder<?, ?> builder() {
        return new IntegrationRevokedBuilderImpl();
    }

    @Generated
    public IntegrationRevokedBuilder<?, ?> toBuilder() {
        return new IntegrationRevokedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getOrganization() {
        return this.organization;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOrganization(UUID organization) {
        this.organization = organization;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationRevoked)) {
            return false;
        }
        IntegrationRevoked other = (IntegrationRevoked)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$organization = this.getOrganization();
        UUID other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegrationRevoked;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegrationRevoked(id=" + this.getId() + ", type=" + this.getType() + ", organization=" + this.getOrganization() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public IntegrationRevoked() {
    }

    @Generated
    private IntegrationRevoked(UUID id, String type, UUID organization, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.organization = organization;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class IntegrationRevokedBuilder<C extends IntegrationRevoked, B extends IntegrationRevokedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID organization;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            IntegrationRevokedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(IntegrationRevoked instance, IntegrationRevokedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.organization(instance.organization);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B organization(UUID organization) {
            this.organization = organization;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "IntegrationRevoked.IntegrationRevokedBuilder(id=" + this.id + ", type=" + this.type + ", organization=" + this.organization + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class IntegrationRevokedBuilderImpl
    extends IntegrationRevokedBuilder<IntegrationRevoked, IntegrationRevokedBuilderImpl> {
        @Generated
        private IntegrationRevokedBuilderImpl() {
        }

        @Override
        @Generated
        protected IntegrationRevokedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IntegrationRevoked build() {
            return new IntegrationRevoked(this);
        }
    }
}

