/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.ponto_connect;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class PaymentRequestClosed
implements IbanityWebhookEvent {
    public static final String TYPE = "pontoConnect.paymentRequest.closed";
    private UUID id;
    private String type;
    private UUID accountId;
    private UUID paymentRequestId;
    private UUID organizationId;
    private Instant createdAt;

    public static Function<DataApiModel, PaymentRequestClosed> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel paymentRequestRelationship;
            RelationshipsApiModel organizationRelationship;
            PaymentRequestClosed paymentRequestClosed = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, PaymentRequestClosed.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                paymentRequestClosed.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((organizationRelationship = dataApiModel.getRelationships().get("organization")) != null) {
                paymentRequestClosed.setOrganizationId(UUID.fromString(organizationRelationship.getData().getId()));
            }
            if ((paymentRequestRelationship = dataApiModel.getRelationships().get("paymentRequest")) != null) {
                paymentRequestClosed.setPaymentRequestId(UUID.fromString(paymentRequestRelationship.getData().getId()));
            }
            return paymentRequestClosed;
        };
    }

    @Generated
    protected PaymentRequestClosed(PaymentRequestClosedBuilder<?, ?> b) {
        this.id = ((PaymentRequestClosedBuilder)b).id;
        this.type = ((PaymentRequestClosedBuilder)b).type;
        this.accountId = ((PaymentRequestClosedBuilder)b).accountId;
        this.paymentRequestId = ((PaymentRequestClosedBuilder)b).paymentRequestId;
        this.organizationId = ((PaymentRequestClosedBuilder)b).organizationId;
        this.createdAt = ((PaymentRequestClosedBuilder)b).createdAt;
    }

    @Generated
    public static PaymentRequestClosedBuilder<?, ?> builder() {
        return new PaymentRequestClosedBuilderImpl();
    }

    @Generated
    public PaymentRequestClosedBuilder<?, ?> toBuilder() {
        return new PaymentRequestClosedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public UUID getPaymentRequestId() {
        return this.paymentRequestId;
    }

    @Generated
    public UUID getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setPaymentRequestId(UUID paymentRequestId) {
        this.paymentRequestId = paymentRequestId;
    }

    @Generated
    public void setOrganizationId(UUID organizationId) {
        this.organizationId = organizationId;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentRequestClosed)) {
            return false;
        }
        PaymentRequestClosed other = (PaymentRequestClosed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$paymentRequestId = this.getPaymentRequestId();
        UUID other$paymentRequestId = other.getPaymentRequestId();
        if (this$paymentRequestId == null ? other$paymentRequestId != null : !((Object)this$paymentRequestId).equals(other$paymentRequestId)) {
            return false;
        }
        UUID this$organizationId = this.getOrganizationId();
        UUID other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentRequestClosed;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $paymentRequestId = this.getPaymentRequestId();
        result = result * 59 + ($paymentRequestId == null ? 43 : ((Object)$paymentRequestId).hashCode());
        UUID $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentRequestClosed(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", paymentRequestId=" + this.getPaymentRequestId() + ", organizationId=" + this.getOrganizationId() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public PaymentRequestClosed() {
    }

    @Generated
    private PaymentRequestClosed(UUID id, String type, UUID accountId, UUID paymentRequestId, UUID organizationId, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.paymentRequestId = paymentRequestId;
        this.organizationId = organizationId;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class PaymentRequestClosedBuilder<C extends PaymentRequestClosed, B extends PaymentRequestClosedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private UUID paymentRequestId;
        @Generated
        private UUID organizationId;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            PaymentRequestClosedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PaymentRequestClosed instance, PaymentRequestClosedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.paymentRequestId(instance.paymentRequestId);
            b.organizationId(instance.organizationId);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B paymentRequestId(UUID paymentRequestId) {
            this.paymentRequestId = paymentRequestId;
            return this.self();
        }

        @Generated
        public B organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "PaymentRequestClosed.PaymentRequestClosedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", paymentRequestId=" + this.paymentRequestId + ", organizationId=" + this.organizationId + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class PaymentRequestClosedBuilderImpl
    extends PaymentRequestClosedBuilder<PaymentRequestClosed, PaymentRequestClosedBuilderImpl> {
        @Generated
        private PaymentRequestClosedBuilderImpl() {
        }

        @Override
        @Generated
        protected PaymentRequestClosedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PaymentRequestClosed build() {
            return new PaymentRequestClosed(this);
        }
    }
}

