/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.xs2a;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class AccountDetailsUpdated
implements IbanityWebhookEvent {
    public static final String TYPE = "xs2a.account.detailsUpdated";
    private UUID id;
    private String type;
    private UUID accountId;
    private UUID synchronizationId;
    private UUID batchSynchronizationId;
    private Instant createdAt;

    public static Function<DataApiModel, AccountDetailsUpdated> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel batchSynchronizationRelationship;
            RelationshipsApiModel synchronizationRelationship;
            AccountDetailsUpdated accountDetailsUpdated = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, AccountDetailsUpdated.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                accountDetailsUpdated.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((synchronizationRelationship = dataApiModel.getRelationships().get("synchronization")) != null) {
                accountDetailsUpdated.setSynchronizationId(UUID.fromString(synchronizationRelationship.getData().getId()));
            }
            if ((batchSynchronizationRelationship = dataApiModel.getRelationships().get("batchSynchronization")) != null) {
                accountDetailsUpdated.setBatchSynchronizationId(UUID.fromString(batchSynchronizationRelationship.getData().getId()));
            }
            return accountDetailsUpdated;
        };
    }

    @Generated
    protected AccountDetailsUpdated(AccountDetailsUpdatedBuilder<?, ?> b) {
        this.id = ((AccountDetailsUpdatedBuilder)b).id;
        this.type = ((AccountDetailsUpdatedBuilder)b).type;
        this.accountId = ((AccountDetailsUpdatedBuilder)b).accountId;
        this.synchronizationId = ((AccountDetailsUpdatedBuilder)b).synchronizationId;
        this.batchSynchronizationId = ((AccountDetailsUpdatedBuilder)b).batchSynchronizationId;
        this.createdAt = ((AccountDetailsUpdatedBuilder)b).createdAt;
    }

    @Generated
    public static AccountDetailsUpdatedBuilder<?, ?> builder() {
        return new AccountDetailsUpdatedBuilderImpl();
    }

    @Generated
    public AccountDetailsUpdatedBuilder<?, ?> toBuilder() {
        return new AccountDetailsUpdatedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public UUID getSynchronizationId() {
        return this.synchronizationId;
    }

    @Generated
    public UUID getBatchSynchronizationId() {
        return this.batchSynchronizationId;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setSynchronizationId(UUID synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    @Generated
    public void setBatchSynchronizationId(UUID batchSynchronizationId) {
        this.batchSynchronizationId = batchSynchronizationId;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountDetailsUpdated)) {
            return false;
        }
        AccountDetailsUpdated other = (AccountDetailsUpdated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$synchronizationId = this.getSynchronizationId();
        UUID other$synchronizationId = other.getSynchronizationId();
        if (this$synchronizationId == null ? other$synchronizationId != null : !((Object)this$synchronizationId).equals(other$synchronizationId)) {
            return false;
        }
        UUID this$batchSynchronizationId = this.getBatchSynchronizationId();
        UUID other$batchSynchronizationId = other.getBatchSynchronizationId();
        if (this$batchSynchronizationId == null ? other$batchSynchronizationId != null : !((Object)this$batchSynchronizationId).equals(other$batchSynchronizationId)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountDetailsUpdated;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $synchronizationId = this.getSynchronizationId();
        result = result * 59 + ($synchronizationId == null ? 43 : ((Object)$synchronizationId).hashCode());
        UUID $batchSynchronizationId = this.getBatchSynchronizationId();
        result = result * 59 + ($batchSynchronizationId == null ? 43 : ((Object)$batchSynchronizationId).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountDetailsUpdated(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", synchronizationId=" + this.getSynchronizationId() + ", batchSynchronizationId=" + this.getBatchSynchronizationId() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public AccountDetailsUpdated() {
    }

    @Generated
    private AccountDetailsUpdated(UUID id, String type, UUID accountId, UUID synchronizationId, UUID batchSynchronizationId, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.synchronizationId = synchronizationId;
        this.batchSynchronizationId = batchSynchronizationId;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class AccountDetailsUpdatedBuilder<C extends AccountDetailsUpdated, B extends AccountDetailsUpdatedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private UUID synchronizationId;
        @Generated
        private UUID batchSynchronizationId;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AccountDetailsUpdatedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AccountDetailsUpdated instance, AccountDetailsUpdatedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.synchronizationId(instance.synchronizationId);
            b.batchSynchronizationId(instance.batchSynchronizationId);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B synchronizationId(UUID synchronizationId) {
            this.synchronizationId = synchronizationId;
            return this.self();
        }

        @Generated
        public B batchSynchronizationId(UUID batchSynchronizationId) {
            this.batchSynchronizationId = batchSynchronizationId;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AccountDetailsUpdated.AccountDetailsUpdatedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", synchronizationId=" + this.synchronizationId + ", batchSynchronizationId=" + this.batchSynchronizationId + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class AccountDetailsUpdatedBuilderImpl
    extends AccountDetailsUpdatedBuilder<AccountDetailsUpdated, AccountDetailsUpdatedBuilderImpl> {
        @Generated
        private AccountDetailsUpdatedBuilderImpl() {
        }

        @Override
        @Generated
        protected AccountDetailsUpdatedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AccountDetailsUpdated build() {
            return new AccountDetailsUpdated(this);
        }
    }
}

