/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.xs2a;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class AccountTransactionsDeleted
implements IbanityWebhookEvent {
    public static final String TYPE = "xs2a.account.transactionsDeleted";
    private UUID id;
    private String type;
    private UUID accountId;
    private UUID transactionDeleteRequestId;
    private Instant deletedBefore;
    private int count;
    private Instant createdAt;

    public static Function<DataApiModel, AccountTransactionsDeleted> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel transactionDeleteRequestRelationship;
            AccountTransactionsDeleted accountTransactionsDeleted = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, AccountTransactionsDeleted.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                accountTransactionsDeleted.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((transactionDeleteRequestRelationship = dataApiModel.getRelationships().get("transactionDeleteRequest")) != null) {
                accountTransactionsDeleted.setTransactionDeleteRequestId(UUID.fromString(transactionDeleteRequestRelationship.getData().getId()));
            }
            return accountTransactionsDeleted;
        };
    }

    @Generated
    protected AccountTransactionsDeleted(AccountTransactionsDeletedBuilder<?, ?> b) {
        this.id = ((AccountTransactionsDeletedBuilder)b).id;
        this.type = ((AccountTransactionsDeletedBuilder)b).type;
        this.accountId = ((AccountTransactionsDeletedBuilder)b).accountId;
        this.transactionDeleteRequestId = ((AccountTransactionsDeletedBuilder)b).transactionDeleteRequestId;
        this.deletedBefore = ((AccountTransactionsDeletedBuilder)b).deletedBefore;
        this.count = ((AccountTransactionsDeletedBuilder)b).count;
        this.createdAt = ((AccountTransactionsDeletedBuilder)b).createdAt;
    }

    @Generated
    public static AccountTransactionsDeletedBuilder<?, ?> builder() {
        return new AccountTransactionsDeletedBuilderImpl();
    }

    @Generated
    public AccountTransactionsDeletedBuilder<?, ?> toBuilder() {
        return new AccountTransactionsDeletedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public UUID getTransactionDeleteRequestId() {
        return this.transactionDeleteRequestId;
    }

    @Generated
    public Instant getDeletedBefore() {
        return this.deletedBefore;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setTransactionDeleteRequestId(UUID transactionDeleteRequestId) {
        this.transactionDeleteRequestId = transactionDeleteRequestId;
    }

    @Generated
    public void setDeletedBefore(Instant deletedBefore) {
        this.deletedBefore = deletedBefore;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountTransactionsDeleted)) {
            return false;
        }
        AccountTransactionsDeleted other = (AccountTransactionsDeleted)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$transactionDeleteRequestId = this.getTransactionDeleteRequestId();
        UUID other$transactionDeleteRequestId = other.getTransactionDeleteRequestId();
        if (this$transactionDeleteRequestId == null ? other$transactionDeleteRequestId != null : !((Object)this$transactionDeleteRequestId).equals(other$transactionDeleteRequestId)) {
            return false;
        }
        Instant this$deletedBefore = this.getDeletedBefore();
        Instant other$deletedBefore = other.getDeletedBefore();
        if (this$deletedBefore == null ? other$deletedBefore != null : !((Object)this$deletedBefore).equals(other$deletedBefore)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountTransactionsDeleted;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $transactionDeleteRequestId = this.getTransactionDeleteRequestId();
        result = result * 59 + ($transactionDeleteRequestId == null ? 43 : ((Object)$transactionDeleteRequestId).hashCode());
        Instant $deletedBefore = this.getDeletedBefore();
        result = result * 59 + ($deletedBefore == null ? 43 : ((Object)$deletedBefore).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountTransactionsDeleted(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", transactionDeleteRequestId=" + this.getTransactionDeleteRequestId() + ", deletedBefore=" + this.getDeletedBefore() + ", count=" + this.getCount() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public AccountTransactionsDeleted() {
    }

    @Generated
    private AccountTransactionsDeleted(UUID id, String type, UUID accountId, UUID transactionDeleteRequestId, Instant deletedBefore, int count, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.transactionDeleteRequestId = transactionDeleteRequestId;
        this.deletedBefore = deletedBefore;
        this.count = count;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class AccountTransactionsDeletedBuilder<C extends AccountTransactionsDeleted, B extends AccountTransactionsDeletedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private UUID transactionDeleteRequestId;
        @Generated
        private Instant deletedBefore;
        @Generated
        private int count;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AccountTransactionsDeletedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AccountTransactionsDeleted instance, AccountTransactionsDeletedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.transactionDeleteRequestId(instance.transactionDeleteRequestId);
            b.deletedBefore(instance.deletedBefore);
            b.count(instance.count);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B transactionDeleteRequestId(UUID transactionDeleteRequestId) {
            this.transactionDeleteRequestId = transactionDeleteRequestId;
            return this.self();
        }

        @Generated
        public B deletedBefore(Instant deletedBefore) {
            this.deletedBefore = deletedBefore;
            return this.self();
        }

        @Generated
        public B count(int count) {
            this.count = count;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AccountTransactionsDeleted.AccountTransactionsDeletedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", transactionDeleteRequestId=" + this.transactionDeleteRequestId + ", deletedBefore=" + this.deletedBefore + ", count=" + this.count + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class AccountTransactionsDeletedBuilderImpl
    extends AccountTransactionsDeletedBuilder<AccountTransactionsDeleted, AccountTransactionsDeletedBuilderImpl> {
        @Generated
        private AccountTransactionsDeletedBuilderImpl() {
        }

        @Override
        @Generated
        protected AccountTransactionsDeletedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AccountTransactionsDeleted build() {
            return new AccountTransactionsDeleted(this);
        }
    }
}

