/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.models.xs2a;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityWebhookEventMapper;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;

public class SynchronizationFailed
implements IbanityWebhookEvent {
    public static final String TYPE = "xs2a.synchronization.failed";
    private UUID id;
    private String type;
    private UUID accountId;
    private UUID synchronizationId;
    private UUID batchSynchronizationId;
    private String synchronizationSubtype;
    private Instant createdAt;

    public static Function<DataApiModel, SynchronizationFailed> mappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel batchSynchronizationRelationship;
            RelationshipsApiModel synchronizationRelationship;
            SynchronizationFailed synchronizationFailed = IbanityWebhookEventMapper.toIbanityWebhooks(dataApiModel, SynchronizationFailed.class);
            RelationshipsApiModel accountRelationship = dataApiModel.getRelationships().get("account");
            if (accountRelationship != null) {
                synchronizationFailed.setAccountId(UUID.fromString(accountRelationship.getData().getId()));
            }
            if ((synchronizationRelationship = dataApiModel.getRelationships().get("synchronization")) != null) {
                synchronizationFailed.setSynchronizationId(UUID.fromString(synchronizationRelationship.getData().getId()));
            }
            if ((batchSynchronizationRelationship = dataApiModel.getRelationships().get("batchSynchronization")) != null) {
                synchronizationFailed.setBatchSynchronizationId(UUID.fromString(batchSynchronizationRelationship.getData().getId()));
            }
            return synchronizationFailed;
        };
    }

    @Generated
    protected SynchronizationFailed(SynchronizationFailedBuilder<?, ?> b) {
        this.id = ((SynchronizationFailedBuilder)b).id;
        this.type = ((SynchronizationFailedBuilder)b).type;
        this.accountId = ((SynchronizationFailedBuilder)b).accountId;
        this.synchronizationId = ((SynchronizationFailedBuilder)b).synchronizationId;
        this.batchSynchronizationId = ((SynchronizationFailedBuilder)b).batchSynchronizationId;
        this.synchronizationSubtype = ((SynchronizationFailedBuilder)b).synchronizationSubtype;
        this.createdAt = ((SynchronizationFailedBuilder)b).createdAt;
    }

    @Generated
    public static SynchronizationFailedBuilder<?, ?> builder() {
        return new SynchronizationFailedBuilderImpl();
    }

    @Generated
    public SynchronizationFailedBuilder<?, ?> toBuilder() {
        return new SynchronizationFailedBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public UUID getAccountId() {
        return this.accountId;
    }

    @Generated
    public UUID getSynchronizationId() {
        return this.synchronizationId;
    }

    @Generated
    public UUID getBatchSynchronizationId() {
        return this.batchSynchronizationId;
    }

    @Generated
    public String getSynchronizationSubtype() {
        return this.synchronizationSubtype;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setSynchronizationId(UUID synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    @Generated
    public void setBatchSynchronizationId(UUID batchSynchronizationId) {
        this.batchSynchronizationId = batchSynchronizationId;
    }

    @Generated
    public void setSynchronizationSubtype(String synchronizationSubtype) {
        this.synchronizationSubtype = synchronizationSubtype;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronizationFailed)) {
            return false;
        }
        SynchronizationFailed other = (SynchronizationFailed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$accountId = this.getAccountId();
        UUID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        UUID this$synchronizationId = this.getSynchronizationId();
        UUID other$synchronizationId = other.getSynchronizationId();
        if (this$synchronizationId == null ? other$synchronizationId != null : !((Object)this$synchronizationId).equals(other$synchronizationId)) {
            return false;
        }
        UUID this$batchSynchronizationId = this.getBatchSynchronizationId();
        UUID other$batchSynchronizationId = other.getBatchSynchronizationId();
        if (this$batchSynchronizationId == null ? other$batchSynchronizationId != null : !((Object)this$batchSynchronizationId).equals(other$batchSynchronizationId)) {
            return false;
        }
        String this$synchronizationSubtype = this.getSynchronizationSubtype();
        String other$synchronizationSubtype = other.getSynchronizationSubtype();
        if (this$synchronizationSubtype == null ? other$synchronizationSubtype != null : !this$synchronizationSubtype.equals(other$synchronizationSubtype)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SynchronizationFailed;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        UUID $synchronizationId = this.getSynchronizationId();
        result = result * 59 + ($synchronizationId == null ? 43 : ((Object)$synchronizationId).hashCode());
        UUID $batchSynchronizationId = this.getBatchSynchronizationId();
        result = result * 59 + ($batchSynchronizationId == null ? 43 : ((Object)$batchSynchronizationId).hashCode());
        String $synchronizationSubtype = this.getSynchronizationSubtype();
        result = result * 59 + ($synchronizationSubtype == null ? 43 : $synchronizationSubtype.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SynchronizationFailed(id=" + this.getId() + ", type=" + this.getType() + ", accountId=" + this.getAccountId() + ", synchronizationId=" + this.getSynchronizationId() + ", batchSynchronizationId=" + this.getBatchSynchronizationId() + ", synchronizationSubtype=" + this.getSynchronizationSubtype() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public SynchronizationFailed() {
    }

    @Generated
    private SynchronizationFailed(UUID id, String type, UUID accountId, UUID synchronizationId, UUID batchSynchronizationId, String synchronizationSubtype, Instant createdAt) {
        this.id = id;
        this.type = type;
        this.accountId = accountId;
        this.synchronizationId = synchronizationId;
        this.batchSynchronizationId = batchSynchronizationId;
        this.synchronizationSubtype = synchronizationSubtype;
        this.createdAt = createdAt;
    }

    @Generated
    public static abstract class SynchronizationFailedBuilder<C extends SynchronizationFailed, B extends SynchronizationFailedBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String type;
        @Generated
        private UUID accountId;
        @Generated
        private UUID synchronizationId;
        @Generated
        private UUID batchSynchronizationId;
        @Generated
        private String synchronizationSubtype;
        @Generated
        private Instant createdAt;

        @Generated
        protected B $fillValuesFrom(C instance) {
            SynchronizationFailedBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SynchronizationFailed instance, SynchronizationFailedBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.accountId(instance.accountId);
            b.synchronizationId(instance.synchronizationId);
            b.batchSynchronizationId(instance.batchSynchronizationId);
            b.synchronizationSubtype(instance.synchronizationSubtype);
            b.createdAt(instance.createdAt);
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B accountId(UUID accountId) {
            this.accountId = accountId;
            return this.self();
        }

        @Generated
        public B synchronizationId(UUID synchronizationId) {
            this.synchronizationId = synchronizationId;
            return this.self();
        }

        @Generated
        public B batchSynchronizationId(UUID batchSynchronizationId) {
            this.batchSynchronizationId = batchSynchronizationId;
            return this.self();
        }

        @Generated
        public B synchronizationSubtype(String synchronizationSubtype) {
            this.synchronizationSubtype = synchronizationSubtype;
            return this.self();
        }

        @Generated
        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public String toString() {
            return "SynchronizationFailed.SynchronizationFailedBuilder(id=" + this.id + ", type=" + this.type + ", accountId=" + this.accountId + ", synchronizationId=" + this.synchronizationId + ", batchSynchronizationId=" + this.batchSynchronizationId + ", synchronizationSubtype=" + this.synchronizationSubtype + ", createdAt=" + this.createdAt + ")";
        }
    }

    @Generated
    private static final class SynchronizationFailedBuilderImpl
    extends SynchronizationFailedBuilder<SynchronizationFailed, SynchronizationFailedBuilderImpl> {
        @Generated
        private SynchronizationFailedBuilderImpl() {
        }

        @Override
        @Generated
        protected SynchronizationFailedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SynchronizationFailed build() {
            return new SynchronizationFailed(this);
        }
    }
}

