/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.webhooks.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import com.ibanity.apis.client.webhooks.models.Key;
import com.ibanity.apis.client.webhooks.services.KeysService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpResponse;

public class KeysServiceImpl
implements KeysService {
    private final IbanityHttpClient ibanityHttpClient;
    private final ApiUrlProvider apiUrlProvider;

    public KeysServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.ibanityHttpClient = ibanityHttpClient;
        this.apiUrlProvider = apiUrlProvider;
    }

    @Override
    public List<Key> list() {
        HttpResponse httpResponse = this.ibanityHttpClient.get(URIHelper.buildUri(this.apiUrlProvider.find("webhooks", "keys")));
        try {
            String payload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            JwksApi jwksApi = (JwksApi)IbanityUtils.objectMapper().readValue(payload, JwksApi.class);
            return jwksApi.getKeys();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Response cannot be parsed", e);
        }
    }

    private static class JwksApi {
        private List<Key> keys;

        @Generated
        private static List<Key> $default$keys() {
            return Collections.emptyList();
        }

        @Generated
        public static JwksApiBuilder builder() {
            return new JwksApiBuilder();
        }

        @Generated
        public List<Key> getKeys() {
            return this.keys;
        }

        @Generated
        public JwksApi() {
            this.keys = JwksApi.$default$keys();
        }

        @Generated
        private JwksApi(List<Key> keys) {
            this.keys = keys;
        }

        @Generated
        public static class JwksApiBuilder {
            @Generated
            private boolean keys$set;
            @Generated
            private List<Key> keys$value;

            @Generated
            JwksApiBuilder() {
            }

            @Generated
            public JwksApiBuilder keys(List<Key> keys) {
                this.keys$value = keys;
                this.keys$set = true;
                return this;
            }

            @Generated
            public JwksApi build() {
                List keys$value = this.keys$value;
                if (!this.keys$set) {
                    keys$value = JwksApi.$default$keys();
                }
                return new JwksApi(keys$value);
            }

            @Generated
            public String toString() {
                return "KeysServiceImpl.JwksApi.JwksApiBuilder(keys$value=" + this.keys$value + ")";
            }
        }
    }
}

