/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.builder.xml;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.io.ReaderInputStream;
import com.ibatis.common.resources.Resources;
import com.ibatis.dao.client.Dao;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoManager;
import com.ibatis.dao.engine.builder.xml.DaoClasspathEntityResolver;
import com.ibatis.dao.engine.impl.DaoContext;
import com.ibatis.dao.engine.impl.DaoImpl;
import com.ibatis.dao.engine.impl.StandardDaoManager;
import com.ibatis.dao.engine.transaction.DaoTransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDaoManagerBuilder {
    private static final String DAO_CONFIG_ELEMENT = "daoConfig";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String CONTEXT_ELEMENT = "context";
    private static final String TRANS_MGR_ELEMENT = "transactionManager";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String DAO_ELEMENT = "dao";
    private Properties properties = null;
    private boolean validationEnabled = true;
    private Map typeAliases = new HashMap();
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$external$ExternalDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$hibernate$HibernateDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$jdbc$JdbcDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$jta$JtaDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$ojb$OjbBrokerTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$sqlmap$SqlMapDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$engine$transaction$toplink$ToplinkDaoTransactionManager;
    static /* synthetic */ Class class$com$ibatis$dao$client$DaoManager;

    public XmlDaoManagerBuilder() {
        this.typeAliases.put("EXTERNAL", (class$com$ibatis$dao$engine$transaction$external$ExternalDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$external$ExternalDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.external.ExternalDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$external$ExternalDaoTransactionManager).getName());
        this.typeAliases.put("HIBERNATE", (class$com$ibatis$dao$engine$transaction$hibernate$HibernateDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$hibernate$HibernateDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.hibernate.HibernateDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$hibernate$HibernateDaoTransactionManager).getName());
        this.typeAliases.put("JDBC", (class$com$ibatis$dao$engine$transaction$jdbc$JdbcDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$jdbc$JdbcDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.jdbc.JdbcDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$jdbc$JdbcDaoTransactionManager).getName());
        this.typeAliases.put("JTA", (class$com$ibatis$dao$engine$transaction$jta$JtaDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$jta$JtaDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.jta.JtaDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$jta$JtaDaoTransactionManager).getName());
        this.typeAliases.put("OJB", (class$com$ibatis$dao$engine$transaction$ojb$OjbBrokerTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$ojb$OjbBrokerTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.ojb.OjbBrokerTransactionManager")) : class$com$ibatis$dao$engine$transaction$ojb$OjbBrokerTransactionManager).getName());
        this.typeAliases.put("SQLMAP", (class$com$ibatis$dao$engine$transaction$sqlmap$SqlMapDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$sqlmap$SqlMapDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.sqlmap.SqlMapDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$sqlmap$SqlMapDaoTransactionManager).getName());
        this.typeAliases.put("TOPLINK", (class$com$ibatis$dao$engine$transaction$toplink$ToplinkDaoTransactionManager == null ? (class$com$ibatis$dao$engine$transaction$toplink$ToplinkDaoTransactionManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.engine.transaction.toplink.ToplinkDaoTransactionManager")) : class$com$ibatis$dao$engine$transaction$toplink$ToplinkDaoTransactionManager).getName());
    }

    public DaoManager buildDaoManager(Reader reader, Properties props) throws DaoException {
        this.properties = props;
        return this.buildDaoManager(reader);
    }

    public DaoManager buildDaoManager(Reader reader) throws DaoException {
        StandardDaoManager daoManager = new StandardDaoManager();
        try {
            Document doc = this.getDoc(reader);
            Element root = (Element)doc.getLastChild();
            String rootname = root.getNodeName();
            if (!DAO_CONFIG_ELEMENT.equals(rootname)) {
                throw new IOException("Error while configuring DaoManager.  The root tag of the DAO configuration XML document must be 'daoConfig'.");
            }
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Properties tempProps;
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (CONTEXT_ELEMENT.equals(child.getNodeName())) {
                    DaoContext daoContext = this.parseContext((Element)child, daoManager);
                    daoManager.addContext(daoContext);
                    continue;
                }
                if (!PROPERTIES_ELEMENT.equals(child.getNodeName())) continue;
                Properties attributes = this.parseAttributes(child);
                if (attributes.containsKey("resource")) {
                    String resource = attributes.getProperty("resource");
                    if (this.properties == null) {
                        this.properties = Resources.getResourceAsProperties((String)resource);
                        continue;
                    }
                    tempProps = Resources.getResourceAsProperties((String)resource);
                    tempProps.putAll((Map<?, ?>)this.properties);
                    this.properties = tempProps;
                    continue;
                }
                if (!attributes.containsKey("url")) continue;
                String url = attributes.getProperty("url");
                if (this.properties == null) {
                    this.properties = Resources.getUrlAsProperties((String)url);
                    continue;
                }
                tempProps = Resources.getUrlAsProperties((String)url);
                tempProps.putAll((Map<?, ?>)this.properties);
                this.properties = tempProps;
            }
        }
        catch (Exception e) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + e.toString(), e);
        }
        return daoManager;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    private DaoContext parseContext(Element contextElement, StandardDaoManager daoManager) throws DaoException {
        DaoContext daoContext = new DaoContext();
        daoContext.setDaoManager(daoManager);
        String id = contextElement.getAttribute("id");
        if (id != null && id.length() > 0) {
            daoContext.setId(id);
        }
        NodeList children = contextElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (TRANS_MGR_ELEMENT.equals(child.getNodeName())) {
                DaoTransactionManager txMgr = this.parseTransactionManager((Element)child);
                daoContext.setTransactionManager(txMgr);
                continue;
            }
            if (!DAO_ELEMENT.equals(child.getNodeName())) continue;
            DaoImpl daoImpl = this.parseDao((Element)child, daoManager, daoContext);
            daoContext.addDao(daoImpl);
        }
        return daoContext;
    }

    private DaoTransactionManager parseTransactionManager(Element transPoolElement) throws DaoException {
        DaoTransactionManager txMgr = null;
        Properties attributes = this.parseAttributes(transPoolElement);
        String implementation = attributes.getProperty("type");
        implementation = this.resolveAlias(implementation);
        try {
            txMgr = (DaoTransactionManager)Class.forName(implementation).newInstance();
        }
        catch (Exception e) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + e.toString(), e);
        }
        Properties props = this.properties;
        if (props == null) {
            props = this.parsePropertyElements(transPoolElement);
        } else {
            props.putAll((Map<?, ?>)this.parsePropertyElements(transPoolElement));
        }
        txMgr.configure(props);
        if (txMgr == null) {
            throw new DaoException("Error while configuring DaoManager.  Some unknown condition caused the DAO Transaction Manager to be null after configuration.");
        }
        return txMgr;
    }

    private DaoImpl parseDao(Element element, StandardDaoManager daoManager, DaoContext daoContext) {
        DaoImpl daoImpl = new DaoImpl();
        if (element.getNodeType() == 1 && DAO_ELEMENT.equals(element.getNodeName())) {
            Properties attributes = this.parseAttributes(element);
            try {
                String iface = attributes.getProperty("interface");
                String impl = attributes.getProperty("implementation");
                daoImpl.setDaoManager(daoManager);
                daoImpl.setDaoContext(daoContext);
                daoImpl.setDaoInterface(Resources.classForName((String)iface));
                daoImpl.setDaoImplementation(Resources.classForName((String)impl));
                Class daoClass = daoImpl.getDaoImplementation();
                Dao dao = null;
                try {
                    Constructor constructor = daoClass.getConstructor(class$com$ibatis$dao$client$DaoManager == null ? (class$com$ibatis$dao$client$DaoManager = XmlDaoManagerBuilder.class$("com.ibatis.dao.client.DaoManager")) : class$com$ibatis$dao$client$DaoManager);
                    dao = (Dao)constructor.newInstance(daoManager);
                }
                catch (Exception e) {
                    dao = (Dao)daoClass.newInstance();
                }
                daoImpl.setDaoInstance(dao);
                daoImpl.initProxy();
            }
            catch (Exception e) {
                throw new DaoException("Error configuring DAO.  Cause: " + e, e);
            }
        }
        return daoImpl;
    }

    private Properties parsePropertyElements(Element propsParentElement) {
        Properties props = new Properties();
        NodeList children = propsParentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !PROPERTY_ELEMENT.equals(child.getNodeName())) continue;
            Properties attributes = this.parseAttributes(child);
            String name = attributes.getProperty("name");
            String value = attributes.getProperty("value");
            props.setProperty(name, value);
        }
        return props;
    }

    private Properties parseAttributes(Node n) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node attribute = attributeNodes.item(i);
            String value = this.parsePropertyTokens(attribute.getNodeValue());
            attributes.put(attribute.getNodeName(), value);
        }
        return attributes;
    }

    private String parsePropertyTokens(String string) {
        String OPEN = "${";
        String CLOSE = "}";
        String newString = string;
        if (newString != null && this.properties != null) {
            int start = newString.indexOf("${");
            int end = newString.indexOf("}");
            while (start > -1 && end > start) {
                String prepend = newString.substring(0, start);
                String append = newString.substring(end + "}".length());
                String propName = newString.substring(start + "${".length(), end);
                String propValue = this.properties.getProperty(propName);
                newString = propValue == null ? prepend + append : prepend + propValue + append;
                start = newString.indexOf("${");
                end = newString.indexOf("}");
            }
        }
        return newString;
    }

    private Document getDoc(Reader reader) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            dbf.setValidating(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(false);
            dbf.setExpandEntityReferences(false);
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new SimpleErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            db.setEntityResolver(new DaoClasspathEntityResolver());
            Document doc = db.parse((InputStream)new ReaderInputStream(reader));
            return doc;
        }
        catch (Exception e) {
            throw new NestedRuntimeException("XML Parser Error.  Cause: " + e);
        }
    }

    private String resolveAlias(String string) {
        String newString = null;
        if (this.typeAliases.containsKey(string)) {
            newString = (String)this.typeAliases.get(string);
        }
        if (newString != null) {
            string = newString;
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SimpleErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        SimpleErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

