/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.impl;

import com.ibatis.dao.client.Dao;
import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoManager;
import com.ibatis.dao.client.DaoTransaction;
import com.ibatis.dao.engine.impl.DaoContext;
import com.ibatis.dao.engine.impl.DaoImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StandardDaoManager
implements DaoManager {
    private static final String DAO_EXPLICIT_TX = "__DAO_EXPLICIT_TX";
    private ThreadLocal transactionMode = new ThreadLocal();
    private ThreadLocal contextInTransactionList = new ThreadLocal();
    private Map idContextMap = new HashMap();
    private Map typeContextMap = new HashMap();
    private Map daoImplMap = new HashMap();

    public void addContext(DaoContext context) {
        if (context.getId() != null && context.getId().length() > 0) {
            if (this.idContextMap.containsKey(context.getId())) {
                throw new DaoException("There is already a DAO Context with the ID '" + context.getId() + "'.");
            }
            this.idContextMap.put(context.getId(), context);
        }
        Iterator i = context.getDaoImpls();
        while (i.hasNext()) {
            DaoImpl daoImpl = (DaoImpl)i.next();
            if (this.typeContextMap.containsKey(daoImpl.getDaoInterface())) {
                this.typeContextMap.put(daoImpl.getDaoInterface(), null);
            } else {
                this.typeContextMap.put(daoImpl.getDaoInterface(), context);
            }
            this.daoImplMap.put(daoImpl.getProxy(), daoImpl);
            this.daoImplMap.put(daoImpl.getDaoInstance(), daoImpl);
        }
    }

    public Dao getDao(Class iface) {
        DaoContext context = (DaoContext)this.typeContextMap.get(iface);
        if (context == null) {
            throw new DaoException("There is no DAO implementation found for " + iface + " in any context. If you've " + "registered multiple implementations of this DAO, you must specify the Context ID for the DAO implementation" + "you're looking for using the getDao(Class iface, String contextId) method.");
        }
        return context.getDao(iface);
    }

    public Dao getDao(Class iface, String contextId) {
        DaoContext context = (DaoContext)this.idContextMap.get(contextId);
        if (context == null) {
            throw new DaoException("There is no Context found with the ID " + contextId + ".");
        }
        return context.getDao(iface);
    }

    public void startTransaction() {
        this.transactionMode.set(DAO_EXPLICIT_TX);
    }

    public void commitTransaction() {
        List ctxList = this.getContextInTransactionList();
        Iterator i = ctxList.iterator();
        while (i.hasNext()) {
            DaoContext context = (DaoContext)i.next();
            context.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        List ctxList = this.getContextInTransactionList();
        try {
            Iterator i = ctxList.iterator();
            while (i.hasNext()) {
                DaoContext context = (DaoContext)i.next();
                context.endTransaction();
            }
        }
        finally {
            this.transactionMode.set(null);
            ctxList.clear();
        }
    }

    public DaoTransaction getTransaction(Dao dao) {
        DaoImpl impl = (DaoImpl)this.daoImplMap.get(dao);
        return impl.getDaoContext().getTransaction();
    }

    public boolean isExplicitTransaction() {
        return DAO_EXPLICIT_TX.equals(this.transactionMode.get());
    }

    public void addContextInTransaction(DaoContext ctx) {
        List ctxList = this.getContextInTransactionList();
        if (!ctxList.contains(ctx)) {
            ctxList.add(ctx);
        }
    }

    private List getContextInTransactionList() {
        ArrayList list = (ArrayList)this.contextInTransactionList.get();
        if (list == null) {
            list = new ArrayList();
            this.contextInTransactionList.set(list);
        }
        return list;
    }
}

