/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.dao.engine.transaction.toplink;

import com.ibatis.dao.client.DaoException;
import com.ibatis.dao.client.DaoTransaction;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import oracle.toplink.threetier.Server;

public class ToplinkDaoTransaction
implements DaoTransaction {
    private Server server;
    private Session session;
    private UnitOfWork unitOfWork;
    private boolean commmitted = false;

    public ToplinkDaoTransaction(UnitOfWork uow, Server server) throws DaoException {
        if (server == null) {
            throw new DaoException("Toplink Server not available");
        }
        this.unitOfWork = uow;
        this.server = server;
    }

    public Session getSession() throws DaoException {
        try {
            if (this.session == null) {
                this.session = this.server.acquireClientSession();
            }
            return this.session;
        }
        catch (TopLinkException e) {
            throw new DaoException("Error aquiring Session", e);
        }
    }

    public UnitOfWork getUnitOfWork() throws DaoException {
        try {
            if (this.unitOfWork == null) {
                this.unitOfWork = this.getSession().acquireUnitOfWork();
            }
            return this.unitOfWork;
        }
        catch (TopLinkException e) {
            throw new DaoException("Error acquiring UnitOfWork.", e);
        }
    }

    public void commit() throws DaoException {
        if (this.commmitted) {
            throw new DaoException("Transaction already committed");
        }
        try {
            if (this.unitOfWork != null) {
                this.unitOfWork.commit();
                this.unitOfWork.release();
                this.session.release();
            }
        }
        catch (TopLinkException e) {
            throw new DaoException("Error committing transaction", e);
        }
        this.commmitted = true;
    }

    public void rollback() throws DaoException {
        if (!this.commmitted) {
            try {
                if (this.unitOfWork != null && this.unitOfWork.isActive()) {
                    this.unitOfWork.revertAndResume();
                    this.unitOfWork.release();
                    this.session.release();
                }
            }
            catch (TopLinkException e) {
                throw new DaoException("Error rolling back transaction", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.unitOfWork.isActive()) {
            this.commit();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.release();
        }
    }
}

