/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.ByteWriter;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;
import org.beetl.core.io.ByteWriter_Char;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.beetl.core.statement.Program;

public class Script<T>
extends Template {
    protected boolean success = false;
    protected Map result = null;
    protected ErrorInfo errorInfo = null;
    protected BeetlException ex = null;
    private boolean done = false;

    protected Script(GroupTemplate gt, Program program, Resource resource, Configuration cf) {
        super(gt, program, resource, cf);
        this.ctx.template = this;
    }

    public void execute() throws BeetlException {
        if (this.done) {
            return;
        }
        StringWriter sw = new StringWriter();
        try {
            this.renderTo(sw);
            this.success = true;
        }
        catch (BeetlException ex) {
            this.success = false;
            this.ex = ex;
            this.errorInfo = new ErrorInfo(ex);
        }
        this.done = true;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map getResult() {
        if (!this.success) {
            throw this.ex;
        }
        if (this.result == null) {
            this.result = this.parseResult();
        }
        return this.result;
    }

    public Object getVar(String varName) {
        return this.getResult().get(varName);
    }

    public T getReturnValue() {
        Map ret = this.getResult();
        return (T)ret.get("return");
    }

    public ErrorInfo getErrorInfo() {
        if (this.isSuccess()) {
            throw new IllegalStateException("\u811a\u672c\u8fd0\u884c\u6210\u529f");
        }
        return this.errorInfo;
    }

    protected Map parseResult() {
        Map<String, Integer> idnexMap = this.program.metaData.getTemplateRootScopeIndexMap();
        Object[] values = this.ctx.vars;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : idnexMap.entrySet()) {
            String name = entry.getKey();
            int index = entry.getValue();
            Object value = values[index];
            result.put(name, value);
        }
        if (values == null) {
            return null;
        }
        Object ret = this.ctx.vars[this.ctx.vars.length - 1];
        if (ret != Context.NOT_EXIST_OBJECT) {
            result.put("return", ret);
        }
        return result;
    }

    @Override
    public void renderTo(Writer writer) throws BeetlException {
        ByteWriter_Char byteWriter = new ByteWriter_Char(writer, this.cf.charset, this.ctx);
        this.renderTo(byteWriter);
    }

    @Override
    public void renderTo(ByteWriter byteWriter) {
        try {
            this.ctx.byteWriter = byteWriter;
            this.ctx.byteOutputMode = this.cf.directByteOutput;
            this.ctx.gt = this.gt;
            if (this.gt.sharedVars != null) {
                for (Map.Entry<String, Object> entry : this.gt.sharedVars.entrySet()) {
                    this.ctx.set(entry.getKey(), entry.getValue());
                }
            }
            this.program.metaData.initContext(this.ctx);
            this.program.execute(this.ctx);
            this.success = true;
        }
        catch (BeetlException e) {
            if (!(this.program instanceof ErrorGrammarProgram)) {
                e.pushResource(this.resource);
            }
            Writer w = BeetlUtil.getWriterByByteWriter(this.ctx.byteWriter);
            e.cr = this.program.metaData.lineSeparator;
            throw e;
        }
    }

    @Override
    public void binding(String varName, Object o) {
        this.ctx.set(varName, o);
    }

    @Override
    public void binding(Map map) {
        Map values = map;
        if (values == null) {
            return;
        }
        for (Map.Entry entry : values.entrySet()) {
            this.binding((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void fastBinding(Map map) {
        this.ctx.globalVar = map;
    }

    @Override
    public Context getCtx() {
        return this.ctx;
    }

    @Override
    public BeetlException validate() {
        if (!(this.program instanceof ErrorGrammarProgram)) {
            return null;
        }
        ErrorGrammarProgram error = (ErrorGrammarProgram)this.program;
        return error.getException();
    }
}

