/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.Writer;
import org.beetl.core.BodyContent;
import org.beetl.core.ByteWriter;
import org.beetl.core.Context;
import org.beetl.core.io.NoLockStringWriter;
import org.beetl.core.io.StringBodyContent;

public final class ByteWriter_Char
extends ByteWriter {
    Writer w;
    String cs;

    public ByteWriter_Char(Writer w, String cs, Context ctx) {
        super(ctx);
        this.w = w;
        this.cs = cs;
    }

    public ByteWriter_Char(Writer w, String cs, Context ctx, ByteWriter parent) {
        this(w, cs, ctx);
        this.parent = parent;
    }

    @Override
    public final void write(char[] cbuf) throws IOException {
        this.w.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int len) throws IOException {
        this.w.write(cbuf, 0, len);
    }

    @Override
    public void writeString(String str) throws IOException {
        if (str != null) {
            int len = str.length();
            char[] buf = this.localBuffer.getCharBuffer(len);
            if (buf.length != 0) {
                str.getChars(0, len, buf, 0);
                this.write(buf, len);
            } else {
                this.w.write(str);
            }
        }
    }

    @Override
    public final void write(byte[] bs) throws IOException {
        this.writeString(new String(bs, this.cs));
    }

    @Override
    public final void write(byte[] bs, int count) throws IOException {
        this.writeString(new String(bs, 0, count, this.cs));
    }

    @Override
    public ByteWriter getTempWriter(ByteWriter parent) {
        return new ByteWriter_Char(new NoLockStringWriter(), this.cs, this.ctx, parent);
    }

    @Override
    public void flush() throws IOException {
        if (this.parent != null) {
            this.parent.flush();
        }
        this.w.flush();
    }

    public String toString() {
        return this.w.toString();
    }

    @Override
    public void fill(ByteWriter bw) throws IOException {
        NoLockStringWriter blw = (NoLockStringWriter)((ByteWriter_Char)bw).w;
        char[] buf = blw.buf;
        this.write(buf, blw.pos);
    }

    @Override
    public BodyContent getTempContent() {
        NoLockStringWriter blw = (NoLockStringWriter)this.w;
        return new StringBodyContent(blw.buf, blw.pos);
    }

    public Writer getW() {
        return this.w;
    }

    public void setW(Writer w) {
        this.w = w;
    }

    public String getCs() {
        return this.cs;
    }

    public void setCs(String cs) {
        this.cs = cs;
    }

    @Override
    public void writeNumberChars(char[] chars, int len) throws IOException {
        this.w.write(chars, 0, len);
    }
}

