/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.Writer;
import org.beetl.core.io.IOUtil;

public class NoLockStringWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 64;
    protected char[] buf;
    protected int pos;

    public NoLockStringWriter() {
        this.buf = new char[64];
    }

    public NoLockStringWriter(int size) {
        this.buf = new char[size];
    }

    @Override
    public void write(char[] src, int off, int len) throws IOException {
        int newPos = this.pos + len;
        if (newPos > this.buf.length) {
            this.buf = IOUtil.copyOf(this.buf, Math.max(this.buf.length << 1, newPos));
        }
        System.arraycopy(src, off, this.buf, this.pos, len);
        this.pos = newPos;
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            this.write(str.toCharArray());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buf, 0, this.pos);
    }
}

