/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import org.beetl.core.ResourceLoader;

public abstract class Resource<T>
implements Serializable {
    protected ResourceLoader resourceLoader = null;
    protected T id = null;

    public Resource(T id, ResourceLoader loader) {
        this.id = id;
        this.resourceLoader = loader;
    }

    public abstract Reader openReader();

    public abstract boolean isModified();

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public T getId() {
        return this.id;
    }

    public String getContent(int start, int end) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        Reader br = this.openReader();
        BufferedReader reader = new BufferedReader(br);
        String line = null;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while ((line = reader.readLine()) != null) {
            if (++index < start || index > end) continue;
            sb.append(line).append(lineSeparator);
            if (index != end) continue;
        }
        reader.close();
        return sb.toString();
    }

    public String toString() {
        return this.id.toString();
    }
}

