/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om.asm;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.asm.ClassDesc;
import org.beetl.core.om.asm.Constants;
import org.beetl.core.om.asm.FieldDesc;
import org.beetl.core.om.asm.MethodDesc;
import org.beetl.ow2.asm.ClassReader;
import org.beetl.ow2.asm.Type;
import org.beetl.ow2.asm.tree.ClassNode;
import org.beetl.ow2.asm.tree.FieldNode;

final class BeanEnhanceUtils
implements Constants {
    private static final Set<String> IGNORE_METHOD_NAME_SET = new HashSet<String>();

    private BeanEnhanceUtils() {
    }

    static ClassDesc getClassDescription(Class<?> beanClass, boolean usePropertyDescriptor) {
        ClassDesc classDesc = new ClassDesc();
        InputStream in = null;
        try {
            BeanEnhanceUtils.setPropertyDescriptors(classDesc, beanClass);
            if (usePropertyDescriptor) {
                BeanEnhanceUtils.buildFieldDescMapByProperty(classDesc);
            } else {
                in = beanClass.getClassLoader().getResourceAsStream(BeanEnhanceUtils.getInternalName(beanClass.getName()) + ".class");
                ClassReader reader = new ClassReader(in);
                ClassNode cn = new ClassNode();
                reader.accept(cn, 0);
                BeanEnhanceUtils.buildFieldDescMapByAsm(classDesc, cn);
            }
            classDesc.target = beanClass;
            classDesc.generalGetMethodDesc = BeanEnhanceUtils.getGeneralGetMethodDescription(beanClass);
            classDesc.hasField = !classDesc.fieldDescMap.isEmpty();
        }
        catch (IntrospectionException | IOException e) {
            throw new BeetlException("ERROR", "ASM\u589e\u5f3a\u529f\u80fd\uff0c\u751f\u6210\u7c7b:" + beanClass.getName() + "\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return classDesc;
    }

    private static void setPropertyDescriptors(ClassDesc classDesc, Class<?> beanClass) throws IntrospectionException {
        PropertyDescriptor[] propDescriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>(propDescriptors.length);
        propList.addAll(Arrays.asList(propDescriptors));
        classDesc.propertyDescriptors = propList;
    }

    private static void buildFieldDescMapByProperty(ClassDesc classDesc) {
        List<PropertyDescriptor> propList = classDesc.propertyDescriptors;
        ArrayList<FieldDesc> fieldDescs = new ArrayList<FieldDesc>(propList.size() << 1);
        for (PropertyDescriptor prop : propList) {
            Method curPropReadMethod = prop.getReadMethod();
            if (curPropReadMethod == null || IGNORE_METHOD_NAME_SET.contains(curPropReadMethod.getName())) continue;
            fieldDescs.add(new FieldDesc(prop.getName(), Type.getType(curPropReadMethod.getReturnType()).toString(), curPropReadMethod.getName(), BeanEnhanceUtils.getMethodDesc(curPropReadMethod)));
            if (prop.getPropertyType() != Boolean.class && prop.getPropertyType() != Boolean.TYPE) continue;
            fieldDescs.add(new FieldDesc(curPropReadMethod.getName(), Type.getType(curPropReadMethod.getReturnType()).toString(), curPropReadMethod.getName(), BeanEnhanceUtils.getMethodDesc(curPropReadMethod)));
        }
        BeanEnhanceUtils.buildFieldDescMap(classDesc, fieldDescs);
    }

    private static void buildFieldDescMap(ClassDesc classDesc, List<FieldDesc> allFieldDescs) {
        allFieldDescs.sort(Comparator.comparingInt(p -> p.name.hashCode()));
        LinkedHashMap<Integer, List<FieldDesc>> filedDescMap = new LinkedHashMap<Integer, List<FieldDesc>>();
        int hashCode = 0;
        ArrayList<FieldDesc> filedDescs = null;
        for (FieldDesc fieldDesc : allFieldDescs) {
            hashCode = fieldDesc.name.hashCode();
            filedDescs = (ArrayList<FieldDesc>)filedDescMap.get(hashCode);
            if (filedDescs == null) {
                filedDescs = new ArrayList<FieldDesc>();
            }
            filedDescs.add(fieldDesc);
            filedDescMap.put(hashCode, filedDescs);
        }
        classDesc.fieldDescMap = filedDescMap;
    }

    private static String getMethodDesc(Method readMethod) {
        String descriptor = Type.getMethodDescriptor(readMethod);
        return descriptor.substring(descriptor.indexOf(40));
    }

    private static void buildFieldDescMapByAsm(ClassDesc classDesc, ClassNode cn) {
        List<FieldNode> fieldList = cn.fields;
        List<FieldDesc> allFiledDescs = BeanEnhanceUtils.convertFieldNodeToFieldDesc(classDesc, fieldList);
        BeanEnhanceUtils.buildFieldDescMap(classDesc, allFiledDescs);
    }

    private static List<FieldDesc> convertFieldNodeToFieldDesc(ClassDesc classDesc, List<FieldNode> fieldList) {
        ArrayList<FieldDesc> fieldDescs = new ArrayList<FieldDesc>(fieldList.size() * 2);
        FieldDesc filedDesc = null;
        for (FieldNode fieldNode : fieldList) {
            filedDesc = new FieldDesc(fieldNode.name, fieldNode.desc, BeanEnhanceUtils.createGetterMethodName(classDesc, fieldNode.name), "()" + fieldNode.desc);
            fieldDescs.add(filedDesc);
            if (!"Z".equals(filedDesc.desc) || !filedDesc.name.startsWith("is")) continue;
            fieldDescs.add(BeanEnhanceUtils.getBooleanFieldDescription(filedDesc));
        }
        return fieldDescs;
    }

    private static FieldDesc getBooleanFieldDescription(FieldDesc curFiledDesc) {
        return new FieldDesc(BeanEnhanceUtils.getFieldNameFromGetterMethod(curFiledDesc.name), curFiledDesc.desc, curFiledDesc.readMethodName, curFiledDesc.readMethodDesc);
    }

    private static String getFieldNameFromGetterMethod(String getterMethodName) {
        String name = getterMethodName.replaceFirst("get", "");
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private static MethodDesc getGeneralGetMethodDescription(Class<?> target) {
        String getStr = "get";
        try {
            Method getMethod = target.getMethod(getStr, Object.class);
            return new MethodDesc(getStr, BeanEnhanceUtils.getMethodDesc(getMethod), "java/lang/Object", BeanEnhanceUtils.getInternalName(getMethod.getReturnType().getName()));
        }
        catch (Exception getMethod) {
            try {
                Method getMethod2 = target.getMethod(getStr, String.class);
                return new MethodDesc(getStr, BeanEnhanceUtils.getMethodDesc(getMethod2), "java/lang/String", BeanEnhanceUtils.getInternalName(getMethod2.getReturnType().getName()));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static String createGetterMethodName(ClassDesc classDesc, String propertyName) {
        for (PropertyDescriptor ps : classDesc.propertyDescriptors) {
            if (ps.getName().equals(propertyName)) {
                return ps.getReadMethod().getName();
            }
            if (!propertyName.startsWith("is") || !ps.getReadMethod().getName().equals(propertyName)) continue;
            return ps.getReadMethod().getName();
        }
        throw new IllegalStateException("\u627e\u4e0d\u5230Getter\u65b9\u6cd5 " + propertyName);
    }

    static String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    static int[] convertIntegerToPrimitiveType(Integer[] source) {
        int[] target = new int[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    static {
        IGNORE_METHOD_NAME_SET.add("getClass");
    }
}

