/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement ifStatement;
    public Statement elseStatement;

    public IfStatement(Expression condition, Statement ifStatement, Statement elseStatement, GrammarToken token) {
        super(token);
        this.condition = condition;
        this.ifStatement = ifStatement;
        this.elseStatement = elseStatement;
    }

    @Override
    public void execute(Context ctx) {
        Object value = this.condition.evaluate(ctx);
        if (this.isSuccess(value)) {
            this.ifStatement.execute(ctx);
        } else if (this.elseStatement != null) {
            this.elseStatement.execute(ctx);
        }
    }

    protected boolean isSuccess(Object value) {
        return ALU.isTrue(value, this);
    }
}

