/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement.optimal;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarRef;

public class VarRefOptimal
extends VarRef {
    public VarAttribute attribute;
    public int varIndex;

    public VarRefOptimal(VarAttribute attribute, GrammarToken token, GrammarToken firstToken) {
        super(null, false, null, token, firstToken);
        this.attribute = attribute;
    }

    @Override
    public Object evaluate(Context ctx) {
        Object value = this.getRefValue(ctx);
        if (value == null) {
            if (this.hasSafe || ctx.safeOutput) {
                return null;
            }
            throw new BeetlException("NULL", "\u7a7a\u6307\u9488").pushToken(this.token);
        }
        try {
            value = this.attribute.evaluate(ctx, value);
        }
        catch (BeetlException ex) {
            ex.pushToken(this.attribute.token);
            if (ex.detailCode == "ATTRIBUTE_NOT_FOUND" && ObjectUtil.hasPrivateAttribute(value.getClass(), this.attribute.token.text)) {
                ex.detailCode = "ATTRIBUTE_NOT_FOUND_PRIVATE";
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex).pushToken(this.attribute.token);
        }
        return value;
    }

    private Object getRefValue(Context ctx) {
        Object value = ctx.vars[this.varIndex];
        if (value != Context.NOT_EXIST_OBJECT) {
            return value;
        }
        if (ctx.globalVar == null || !ctx.globalVar.containsKey("_root")) {
            return null;
        }
        Object root = ctx.getGlobal("_root");
        if (root == null) {
            return null;
        }
        String attr = this.firstToken.text;
        AttributeAccess aa = AABuilder.buildFiledAccessor(root.getClass());
        try {
            value = aa.value(root, attr);
        }
        catch (RuntimeException e) {
            throw new BeetlException("ATTRIBUTE_INVALID", "_root " + root.getClass() + " \u5c5e\u6027\u8bbf\u95ee\u9519\u8bef").pushToken(this.firstToken);
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }
}

