/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.impl.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.beetl.core.Configuration;
import org.beetl.core.runtime.IBeetlCache;

public class DefaultBeetlCache
implements IBeetlCache {
    private final Map<Object, Object> threadSafeCache = new ConcurrentHashMap<Object, Object>();

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public Object get(Object key) {
        return this.threadSafeCache.get(key);
    }

    @Override
    public Object get(Object key, Function function) {
        Object o = this.threadSafeCache.get(key);
        if (o != null) {
            return o;
        }
        return this.threadSafeCache.computeIfAbsent(key, function);
    }

    @Override
    public void remove(Object key) {
        this.threadSafeCache.remove(key);
    }

    @Override
    public void set(Object key, Object value) {
        this.threadSafeCache.put(key, value);
    }

    @Override
    public void clearAll() {
        this.threadSafeCache.clear();
    }

    @Override
    public long size() {
        return this.threadSafeCache.size();
    }
}

