/*
 * Decompiled with CFR 0.152.
 */
package com.ibeetl.starter;

import org.springframework.core.env.Environment;

public class BeetlSqlProperties {
    String basePackage = null;
    String daoSuffix = null;
    String sqlPath = null;
    String nameConversion = null;
    String dbStyle = null;
    Boolean dev = true;

    public BeetlSqlProperties(Environment env) {
        this.basePackage = env.getProperty("beetlsql.basePackage", "com");
        this.daoSuffix = env.getProperty("beetlsql.daoSuffix", "Dao");
        this.sqlPath = env.getProperty("beetlsql.sqlPath", "/sql");
        this.nameConversion = env.getProperty("beetlsql.nameConversion", "org.beetl.sql.core.UnderlinedNameConversion");
        this.dbStyle = env.getProperty("beetlsql.dbStyle", "org.beetl.sql.core.db.MySqlStyle");
        this.dev = (Boolean)env.getProperty("beetl-beetlsql.dev", Boolean.class, (Object)true);
    }

    public BeetlSqlProperties(Environment env, String datasourceName) {
        this.basePackage = env.getProperty("beetlsql.ds." + datasourceName + ".basePackage", "com");
        this.daoSuffix = env.getProperty("beetlsql.ds." + datasourceName + ".daoSuffix", "Dao");
        this.sqlPath = env.getProperty("beetlsql.ds." + datasourceName + ".sqlPath", "/sql");
        this.nameConversion = env.getProperty("beetlsql.ds." + datasourceName + ".nameConversion", "org.beetl.sql.core.UnderlinedNameConversion");
        this.dbStyle = env.getProperty("beetlsql.ds." + datasourceName + ".dbStyle", "org.beetl.sql.core.db.MySqlStyle");
        this.dev = (Boolean)env.getProperty("beetl-beetlsql.dev", Boolean.class, (Object)true);
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getDaoSuffix() {
        return this.daoSuffix;
    }

    public void setDaoSuffix(String daoSuffix) {
        this.daoSuffix = daoSuffix;
    }

    public String getSqlPath() {
        return this.sqlPath;
    }

    public void setSqlPath(String sqlPath) {
        this.sqlPath = sqlPath;
    }

    public String getNameConversion() {
        return this.nameConversion;
    }

    public void setNameConversion(String nameConversion) {
        this.nameConversion = nameConversion;
    }

    public String getDbStyle() {
        return this.dbStyle;
    }

    public void setDbStyle(String dbStyle) {
        this.dbStyle = dbStyle;
    }

    public Boolean getDev() {
        return this.dev;
    }

    public void setDev(Boolean dev) {
        this.dev = dev;
    }
}

