/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.lang.ref.SoftReference;

public class ContextLocalBuffer {
    public static int charBufferSize = 256;
    public static int byteBufferSize = 256;
    private char[] charBuffer = new char[charBufferSize];
    private byte[] byteBuffer = new byte[byteBufferSize];
    static ThreadLocal<SoftReference<ContextLocalBuffer>> threadLocal = new ThreadLocal<SoftReference<ContextLocalBuffer>>(){

        @Override
        protected SoftReference<ContextLocalBuffer> initialValue() {
            return new SoftReference<ContextLocalBuffer>(new ContextLocalBuffer());
        }
    };

    public static ContextLocalBuffer get() {
        SoftReference<ContextLocalBuffer> re = threadLocal.get();
        ContextLocalBuffer ctxBuffer = re.get();
        if (ctxBuffer == null) {
            ctxBuffer = new ContextLocalBuffer();
            threadLocal.set(new SoftReference<ContextLocalBuffer>(ctxBuffer));
        }
        return ctxBuffer;
    }

    public char[] getCharBuffer() {
        return this.charBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public char[] getCharBuffer(int expected) {
        if (this.charBuffer.length >= expected) {
            return this.charBuffer;
        }
        this.charBuffer = new char[(int)((double)expected * 1.2)];
        return this.charBuffer;
    }

    public byte[] getByteBuffer(int expected) {
        if (this.byteBuffer.length >= expected) {
            return this.byteBuffer;
        }
        this.byteBuffer = new byte[(int)((double)expected * 1.2)];
        return this.byteBuffer;
    }
}

