/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.beetl.core.Configuration;
import org.beetl.core.ErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.WebAppResourceLoader;
import org.beetl.ext.spring.AbstractGroupTemplateConfig;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public class BeetlGroupUtilConfiguration
extends AbstractGroupTemplateConfig
implements ServletContextAware {
    protected GroupTemplate groupTemplate;
    protected String root = "/";
    protected String webPath = null;
    protected Properties configProperties = null;
    protected Resource configFileResource = null;
    protected ResourceLoader resourceLoader = null;
    protected ErrorHandler errorHandler = null;
    protected Map<String, Object> sharedVars = null;

    public void init() {
        try {
            this.initGroupTemplate();
            this.config(this.groupTemplate);
            this.initOther();
        }
        catch (IOException e) {
            throw new RuntimeException("\u52a0\u8f7dGroupTemplate\u5931\u8d25", e);
        }
    }

    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    public void setConfigFileResource(Resource configFileResource) {
        this.configFileResource = configFileResource;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSharedVars(Map<String, Object> sharedVars) {
        this.sharedVars = sharedVars;
    }

    public void setServletContext(ServletContext sc) {
        this.webPath = sc.getRealPath("/");
        if (this.webPath != null) {
            this.root = this.webPath + this.root;
        }
    }

    private void initGroupTemplate() throws IOException {
        Configuration configuration = null;
        if (this.configProperties == null && this.configFileResource == null) {
            configuration = Configuration.defaultConfiguration();
        } else {
            Properties properties = new Properties();
            if (this.configFileResource != null) {
                InputStream in = null;
                try {
                    in = this.configFileResource.getInputStream();
                    properties.load(in);
                }
                catch (IOException ex) {
                    throw ex;
                }
                finally {
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                }
            }
            if (this.configProperties != null) {
                Enumeration<?> keys = this.configProperties.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = this.configProperties.getProperty(key);
                    properties.setProperty(key, value);
                }
            }
            configuration = new Configuration(properties);
        }
        if (this.resourceLoader != null) {
            this.groupTemplate = new GroupTemplate(this.resourceLoader, configuration);
        } else {
            WebAppResourceLoader defaultLoader = new WebAppResourceLoader(this.root);
            this.groupTemplate = new GroupTemplate(defaultLoader, configuration);
        }
        if (this.errorHandler != null) {
            this.groupTemplate.setErrorHandler(this.errorHandler);
        }
        if (this.sharedVars != null) {
            this.groupTemplate.setSharedVars(this.sharedVars);
        }
    }

    protected void initOther() {
    }

    public GroupTemplate getGroupTemplate() {
        return this.groupTemplate;
    }

    public void setRoot(String root) {
        this.root = root;
    }
}

